/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;

public final class ArtConstants {
    public static final String ART_NAME = "Android Runtime (ART)";
    public static final String MAGIC = "art\n";
    public static final int VERSION_LENGTH = 4;
    public static final String VERSION_KITKAT_RELEASE = "005";
    public static final String VERSION_LOLLIPOP_RELEASE = "009";
    public static final String VERSION_LOLLIPOP_MR1_WFC_RELEASE = "012";
    public static final String VERSION_MARSHMALLOW_RELEASE = "017";
    public static final String VERSION_NOUGAT_RELEASE = "029";
    public static final String VERSION_NOUGAT_MR2_PIXEL_RELEASE = "030";
    public static final String VERSION_OREO_RELEASE = "043";
    public static final String VERSION_OREO_DR1_RELEASE = "044";
    public static final String VERSION_OREO_MR1_RELEASE = "046";
    public static final String VERSION_PIE_RELEASE = "056";
    public static final String VERSION_10_RELEASE = "074";
    public static final String VERSION_11_RELEASE = "085";
    public static final String VERSION_12_RELEASE = "099";
    public static final String[] SUPPORTED_VERSIONS = new String[]{"005", "009", "012", "017", "029", "030", "043", "044", "046", "056", "074", "085", "099"};

    public static final boolean isSupportedVersion(String version) {
        for (String supportedVersion : SUPPORTED_VERSIONS) {
            if (!supportedVersion.equals(version)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isART(Program program) {
        if (program != null) {
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                try {
                    byte[] bytes = new byte[MAGIC.length()];
                    block.getBytes(block.getStart(), bytes);
                    String magic = new String(bytes);
                    if (MAGIC.equals(magic)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static final Address findART(Program program) {
        if (program != null) {
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                try {
                    byte[] bytes = new byte[MAGIC.length()];
                    block.getBytes(block.getStart(), bytes);
                    String magic = new String(bytes);
                    if (MAGIC.equals(magic)) {
                        return block.getStart();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

