/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DemanglerUtil {
    private static final Pattern LEADING_PARAMETER_SPACE_PATTERN = Pattern.compile(" ([\\*\\&\\)])");
    private static final Pattern TRAILING_PARAMETER_SPACE_PATTERN = Pattern.compile("([\\(\\,]) ");

    public static DemangledObject demangle(String mangled) {
        List<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                DemangledObject demangledObject = demangler.demangle(mangled);
                if (demangledObject == null) continue;
                return demangledObject;
            }
            catch (DemangledException demangledException) {
            }
        }
        return null;
    }

    public static DemangledObject demangle(Program program, String mangled) {
        List<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                DemangledObject demangledObject;
                if (!demangler.canDemangle(program) || (demangledObject = demangler.demangle(mangled)) == null) continue;
                return demangledObject;
            }
            catch (DemangledException demangledException) {
            }
        }
        return null;
    }

    private static List<Demangler> getDemanglers() {
        return ClassSearcher.getInstances(Demangler.class);
    }

    public static String stripSuperfluousSignatureSpaces(String str) {
        return DemanglerUtil.replace(DemanglerUtil.replace(str, LEADING_PARAMETER_SPACE_PATTERN), TRAILING_PARAMETER_SPACE_PATTERN);
    }

    private static String replace(String str, Pattern spaceCleanerPattern) {
        Matcher matcher = spaceCleanerPattern.matcher(str);
        StringBuilder buffy = new StringBuilder();
        while (matcher.find()) {
            String captureGroup = matcher.group(1);
            matcher.appendReplacement(buffy, captureGroup);
        }
        matcher.appendTail(buffy);
        return buffy.toString();
    }
}

