/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import java.io.IOException;

public class CliSigAssembly
extends CliAbstractSig {
    byte[] sha1Hash = new byte[20];
    int bitLength;
    int publicExponent;
    byte[] publicKeySignature;
    private static final int CLISIGASSEMBLY_RSA1_MAGIC = 826364754;
    private static final int CLISIGASSEMBLY_SHA1_LENGTH = 20;
    private static final int BITS_PER_BYTE = 8;

    public CliSigAssembly(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = blob.getContentsReader();
        this.sha1Hash = reader.readNextByteArray(20);
        if (reader.readNextUnsignedInt() != 826364754L) {
            Msg.warn((Object)this, (Object)("An Assembly blob was found without the expected RSA1 signature: " + this.getName()));
            return;
        }
        this.bitLength = reader.readNextInt();
        this.publicExponent = reader.readNextInt();
        this.publicKeySignature = reader.readNextByteArray(this.bitLength / 8);
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add((DataType)new ArrayDataType(BYTE, this.sha1Hash.length, 1), "sha1", "SHA1 hash");
        struct.add(DWORD, "_RSAPUBKEY.magic", "RSA1 Magic");
        struct.add(DWORD, "_RSAPUBKEY.bitlen", "");
        struct.add(DWORD, "_RSAPUBKEY.pubexp", "");
        struct.add((DataType)new ArrayDataType(BYTE, this.publicKeySignature.length, 1), "pubkey", "Public Key");
        return struct;
    }

    @Override
    public String getContentsName() {
        return "AssemblySig";
    }

    @Override
    public String getContentsComment() {
        return "Data describing an Assembly signature";
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        return String.format("Assembly:\r\tSHA1: %s\r\tBit length: %d\r\tPublic exponent: %d\r\tSignature: %s", this.sha1Hash.toString(), this.bitLength, this.publicExponent, this.publicKeySignature);
    }
}

