/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import java.util.HashSet;
import java.util.Set;

public enum SectionFlags {
    IMAGE_SCN_TYPE_NO_PAD("IMAGE_SCN_TYPE_NO_PAD", 8, "The section should not be padded to the next boundary."),
    IMAGE_SCN_RESERVED_0001("IMAGE_SCN_RESERVED_0001", 16, "Reserved for future use."),
    IMAGE_SCN_CNT_CODE("IMAGE_SCN_CNT_CODE", 32, "The section contains executable code."),
    IMAGE_SCN_CNT_INITIALIZED_DATA("IMAGE_SCN_CNT_INITIALIZED_DATA", 64, "The section contains initialized data."),
    IMAGE_SCN_CNT_UNINITIALIZED_DATA("IMAGE_SCN_CNT_UNINITIALIZED_DATA", 128, "The section contains uninitialized data."),
    IMAGE_SCN_LNK_OTHER("IMAGE_SCN_LNK_OTHER", 256, "Reserved for future use."),
    IMAGE_SCN_LNK_INFO("IMAGE_SCN_LNK_INFO", 512, "The section contains comments or other information.This is valid for object files only."),
    IMAGE_SCN_RESERVED_0040("IMAGE_SCN_RESERVED_0040", 1024, "Reserved for future use."),
    IMAGE_SCN_LNK_REMOVE("IMAGE_SCN_LNK_REMOVE", 2048, "The section will not become part of the image. This is valid only for object files."),
    IMAGE_SCN_LNK_COMDAT("IMAGE_SCN_LNK_COMDAT", 4096, "The section contains COMDAT data. This is valid only for object files."),
    IMAGE_SCN_GPREL("IMAGE_SCN_GPREL", 32768, "The section contains data referenced through the global pointer (GP)."),
    IMAGE_SCN_MEM_PURGEABLE("IMAGE_SCN_MEM_PURGEABLE", 131072, "Reserved for future use."),
    IMAGE_SCN_MEM_16BIT("IMAGE_SCN_MEM_16BIT", 131072, "Reserved for future use."),
    IMAGE_SCN_MEM_LOCKED("IMAGE_SCN_MEM_LOCKED", 262144, "Reserved for future use."),
    IMAGE_SCN_MEM_PRELOAD("IMAGE_SCN_MEM_PRELOAD", 524288, "Reserved for future use."),
    IMAGE_SCN_ALIGN_1BYTES("IMAGE_SCN_ALIGN_1BYTES", 0x100000, "Align data on a 1-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_2BYTES("IMAGE_SCN_ALIGN_2BYTES", 0x200000, "Align data on a 2-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_4BYTES("IMAGE_SCN_ALIGN_4BYTES", 0x300000, "Align data on a 4-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_8BYTES("IMAGE_SCN_ALIGN_8BYTES", 0x400000, "Align data on an 8-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_16BYTES("IMAGE_SCN_ALIGN_16BYTES", 0x500000, "Align data on a 16-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_32BYTES("IMAGE_SCN_ALIGN_32BYTES", 0x600000, "Align data on a 32-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_64BYTES("IMAGE_SCN_ALIGN_64BYTES", 0x700000, "Align data on a 64-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_128BYTES("IMAGE_SCN_ALIGN_128BYTES", 0x800000, "Align data on a 128-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_256BYTES("IMAGE_SCN_ALIGN_256BYTES", 0x900000, "Align data on a 256-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_512BYTES("IMAGE_SCN_ALIGN_512BYTES", 0xA00000, "Align data on a 512-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_1024BYTES("IMAGE_SCN_ALIGN_1024BYTES", 0xB00000, "Align data on a 1024-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_2048BYTES("IMAGE_SCN_ALIGN_2048BYTES", 0xC00000, "Align data on a 2048-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_4096BYTES("IMAGE_SCN_ALIGN_4096BYTES", 0xD00000, "Align data on a 4096-byte boundary. Valid only for object files."),
    IMAGE_SCN_ALIGN_8192BYTES("IMAGE_SCN_ALIGN_8192BYTES", 0xE00000, "Align data on an 8192-byte boundary. Valid only for object files."),
    IMAGE_SCN_LNK_NRELOC_OVFL("IMAGE_SCN_LNK_NRELOC_OVFL", 0x1000000, "The section contains extended relocations."),
    IMAGE_SCN_MEM_DISCARDABLE("IMAGE_SCN_MEM_DISCARDABLE", 0x2000000, "The section can be discarded as needed."),
    IMAGE_SCN_MEM_NOT_CACHED("IMAGE_SCN_MEM_NOT_CACHED", 0x4000000, "The section cannot be cached."),
    IMAGE_SCN_MEM_NOT_PAGED("IMAGE_SCN_MEM_NOT_PAGED", 0x8000000, "The section is not pageable."),
    IMAGE_SCN_MEM_SHARED("IMAGE_SCN_MEM_SHARED", 0x10000000, "The section can be shared in memory."),
    IMAGE_SCN_MEM_EXECUTE("IMAGE_SCN_MEM_EXECUTE", 0x20000000, "The section can be executed as code."),
    IMAGE_SCN_MEM_READ("IMAGE_SCN_MEM_READ", 0x40000000, "The section can be read."),
    IMAGE_SCN_MEM_WRITE("IMAGE_SCN_MEM_WRITE", Integer.MIN_VALUE, "The section can be written to.");

    private final String alias;
    private final int mask;
    private final String description;

    private SectionFlags(String alias, int mask, String description) {
        this.alias = alias;
        this.mask = mask;
        this.description = description;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getMask() {
        return this.mask;
    }

    public String getDescription() {
        return this.description;
    }

    public static Set<SectionFlags> resolveFlags(int value) {
        HashSet<SectionFlags> applied = new HashSet<SectionFlags>();
        for (SectionFlags ch : SectionFlags.values()) {
            if ((ch.getMask() & value) != ch.getMask()) continue;
            applied.add(ch);
        }
        return applied;
    }
}

