/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_Method
extends ObjectiveC_Method {
    private String name;
    private String signature;
    private int address;

    ObjectiveC1_Method(ObjectiveC1_State state, BinaryReader reader, ObjectiveC_MethodType methodType) throws IOException {
        super(state, reader, methodType);
        this.name = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.signature = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.address = reader.readNextInt();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypes() {
        return this.signature;
    }

    @Override
    public long getImplementation() {
        return (long)this.address & 0xFFFFFFFFL;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_method", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "method_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "method_types", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)VOID, (int)this._state.pointerSize), "method_imp", null);
        return struct;
    }
}

