/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.DomainFileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.listing.DataTypeArchive;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ProjectArchive
implements DomainFileArchive {
    private static ImageIcon CLOSED_ICON = ResourceManager.loadImage((String)"images/closedBookBlue.png");
    private static ImageIcon OPEN_ICON = ResourceManager.loadImage((String)"images/openBookBlue.png");
    private DataTypeArchive dataTypeArchive;
    private DomainFile originalDomainFile;
    DataTypeManagerChangeListener categoryListener;
    private DataTypeManagerHandler archiveManager;
    private DataTypeManager dataTypeManager;

    ProjectArchive(DataTypeManagerHandler archiveManager, DataTypeArchive dataTypeArchive, DomainFile originalDomainFile) {
        this.archiveManager = archiveManager;
        this.dataTypeArchive = dataTypeArchive;
        this.dataTypeManager = dataTypeArchive.getDataTypeManager();
        this.originalDomainFile = originalDomainFile;
        this.categoryListener = new ArchiveCategoryChangeListener();
        this.dataTypeManager.addDataTypeManagerListener(this.categoryListener);
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    @Override
    public String getName() {
        return this.dataTypeManager.getName();
    }

    @Override
    public int compareTo(Archive archive) {
        if (archive instanceof BuiltInArchive || archive instanceof ProgramArchive) {
            return 1;
        }
        if (archive instanceof ProjectArchive) {
            return this.getName().compareToIgnoreCase(archive.getName());
        }
        return -1;
    }

    @Override
    public boolean isModifiable() {
        DomainFile domainFile = this.getDomainObject().getDomainFile();
        return domainFile.canSave();
    }

    @Override
    public DomainFile getDomainFile() {
        return this.originalDomainFile;
    }

    public DataTypeArchive getDomainObject() {
        return this.dataTypeArchive;
    }

    @Override
    public boolean isChanged() {
        DomainFile domainFile = this.dataTypeArchive.getDomainFile();
        long lastModifiedTime = domainFile.getLastModifiedTime();
        return lastModifiedTime == 0L || this.dataTypeArchive.isChanged();
    }

    @Override
    public boolean isSavable() {
        return !this.dataTypeArchive.getDomainFile().isReadOnly() && this.dataTypeArchive.isChangeable();
    }

    @Override
    public void save() throws IOException {
        this.archiveManager.save((UndoableDomainObject)this.getDomainObject());
    }

    @Override
    public void close() {
        this.dataTypeManager.close();
        this.archiveManager.archiveClosed(this);
        this.dataTypeManager = null;
    }

    @Override
    public void saveAs(Component component) throws IOException {
        this.archiveManager.saveAs((UndoableDomainObject)this.dataTypeArchive);
        this.originalDomainFile = this.dataTypeArchive.getDomainFile();
        this.dataTypeArchive.updateID();
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return expanded ? OPEN_ICON : CLOSED_ICON;
    }

    private void fireStateChanged() {
        this.archiveManager.fireArchiveStateChanged(this);
    }

    class ArchiveCategoryChangeListener
    implements DataTypeManagerChangeListener {
        ArchiveCategoryChangeListener() {
        }

        public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
            ProjectArchive.this.fireStateChanged();
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            ProjectArchive.this.fireStateChanged();
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
            ProjectArchive.this.fireStateChanged();
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            if (!oldPath.equals((Object)newPath)) {
                ProjectArchive.this.fireStateChanged();
            }
        }

        public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
            ProjectArchive.this.fireStateChanged();
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            ProjectArchive.this.fireStateChanged();
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            ProjectArchive.this.fireStateChanged();
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            ProjectArchive.this.fireStateChanged();
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            ProjectArchive.this.fireStateChanged();
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            ProjectArchive.this.fireStateChanged();
        }

        public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
        }

        public void sourceArchiveAdded(DataTypeManager dtm, SourceArchive dataTypeSource) {
            ProjectArchive.this.fireStateChanged();
        }

        public void sourceArchiveChanged(DataTypeManager dtm, SourceArchive dataTypeSource) {
            ProjectArchive.this.fireStateChanged();
        }
    }
}

