/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.LongDataType;

public class UnsignedLongDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final UnsignedLongDataType dataType = new UnsignedLongDataType();

    public UnsignedLongDataType() {
        this(null);
    }

    public UnsignedLongDataType(DataTypeManager dtm) {
        super("ulong", false, dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getLongSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Unsigned Long Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "unsigned long";
    }

    @Override
    public LongDataType getOppositeSignednessDataType() {
        return LongDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public UnsignedLongDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new UnsignedLongDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), "unsigned long", false);
    }
}

