/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CharsetInfo {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF32 = "UTF-32";
    public static final String USASCII = "US-ASCII";
    private Map<String, CharsetInfoRec> charsetInfoRecsByName = new HashMap<String, CharsetInfoRec>();
    private List<String> charsetNamesList = new ArrayList<String>();
    private String[] charsetNames;

    public static CharsetInfo getInstance() {
        return Singleton.INSTANCE;
    }

    public static boolean isBOMCharset(String charsetName) {
        return UTF32.equals(charsetName) || UTF16.equals(charsetName);
    }

    private CharsetInfo() {
        this.initialize(false);
    }

    private void initialize(boolean includeConfigFile) {
        this.registerStandardCharsets();
        if (includeConfigFile) {
            this.readConfigFile();
        }
        this.addJVMAvailableCharsets();
        this.charsetNames = this.charsetNamesList.toArray(new String[this.charsetNamesList.size()]);
    }

    public static void reinitializeWithUserDefinedCharsets() {
        CharsetInfo.getInstance().initialize(true);
    }

    private void registerStandardCharsets() {
        this.addCharset(USASCII, 1);
        this.addCharset(UTF8, 1);
        this.addCharset("ISO-8859-1", 1);
        this.addCharset(UTF16, 2);
        this.addCharset("UTF-16BE", 2);
        this.addCharset("UTF-16LE", 2);
        this.addCharset(UTF32, 4);
        this.addCharset("UTF-32BE", 4);
        this.addCharset("UTF-32LE", 4);
    }

    private void addCharset(String name, int charSize) {
        CharsetInfoRec rec = new CharsetInfoRec(name, charSize);
        this.charsetInfoRecsByName.put(name, rec);
        this.charsetNamesList.add(name);
    }

    public String[] getCharsetNames() {
        return this.charsetNames;
    }

    public int getCharsetCharSize(String charsetName) {
        CharsetInfoRec rec = this.charsetInfoRecsByName.get(charsetName);
        return rec != null ? rec.charSize : 1;
    }

    public List<String> getCharsetNamesWithCharSize(int size) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.charsetNames) {
            if (this.getCharsetCharSize(name) != size) continue;
            names.add(name);
        }
        return names;
    }

    private void addJVMAvailableCharsets() {
        for (String csName : Charset.availableCharsets().keySet()) {
            if (this.charsetInfoRecsByName.containsKey(csName)) continue;
            this.addCharset(csName, 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readConfigFile() {
        ResourceFile xmlFile = Application.findDataFileInAnyModule((String)"charset_info.xml");
        try (InputStream xmlInputStream = xmlFile.getInputStream();){
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document doc = sax.build(xmlInputStream);
            Element root = doc.getRootElement();
            for (Element child : root.getChildren("charset")) {
                try {
                    String name = child.getAttributeValue("name");
                    if (name == null || name.trim().isEmpty()) {
                        throw new IOException("Bad charset definition in " + xmlFile);
                    }
                    if (!Charset.isSupported(name)) {
                        Msg.warn((Object)this, (Object)("Unsupported charset defined in " + xmlFile.getName() + ": " + name));
                    }
                    int charSize = XmlUtilities.parseBoundedIntAttr((Element)child, (String)"charSize", (int)1, (int)8);
                    this.addCharset(name, charSize);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Invalid charset definition in " + xmlFile);
                    return;
                }
            }
        }
        catch (IOException | JDOMException e) {
            Msg.showError((Object)this, null, (String)"Error reading charset data", (Object)e.getMessage(), (Throwable)e);
        }
    }

    private static class CharsetInfoRec {
        final String name;
        final int charSize;

        CharsetInfoRec(String name, int charSize) {
            this.name = name;
            this.charSize = charSize;
        }
    }

    private static final class Singleton {
        private static final CharsetInfo INSTANCE = new CharsetInfo();

        private Singleton() {
        }
    }
}

