/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.complex.Complex;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.Complex16DataType;
import ghidra.program.model.data.Complex32DataType;
import ghidra.program.model.data.Complex8DataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DoubleComplexDataType;
import ghidra.program.model.data.FloatComplexDataType;
import ghidra.program.model.data.LongDoubleComplexDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.WrappedMemBuffer;
import java.math.BigDecimal;

public abstract class AbstractComplexDataType
extends BuiltIn {
    private final AbstractFloatDataType floatType;

    protected static AbstractComplexDataType getDefaultComplexDataType(int size) {
        if (size == 8) {
            return Complex8DataType.dataType;
        }
        if (size == 16) {
            return Complex16DataType.dataType;
        }
        if (size == 32) {
            return Complex32DataType.dataType;
        }
        return null;
    }

    public static DataType getComplexDataType(int size, DataTypeManager dtm) {
        AbstractComplexDataType dt;
        DataOrganization dataOrganization;
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (size % 2 != 0) {
            return Undefined.getUndefinedDataType(size);
        }
        int floatSize = size / 2;
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (floatSize == dataOrganization.getFloatSize()) {
                return FloatComplexDataType.dataType.clone(dtm);
            }
            if (floatSize == dataOrganization.getDoubleSize()) {
                return DoubleComplexDataType.dataType.clone(dtm);
            }
            if (floatSize == dataOrganization.getLongDoubleSize()) {
                return LongDoubleComplexDataType.dataType.clone(dtm);
            }
        }
        if ((dt = AbstractComplexDataType.getDefaultComplexDataType(size)) == null) {
            return Undefined.getUndefinedDataType(size);
        }
        return dt;
    }

    public AbstractComplexDataType(String name, AbstractFloatDataType floats, DataTypeManager dtm) {
        super(null, name, dtm);
        this.floatType = floats;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.floatType.getLength() * 2;
    }

    @Override
    public String getDescription() {
        return "The data type for a complex number: a + bi";
    }

    private static double toDouble(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)obj;
            return bd.doubleValue();
        }
        throw new IllegalArgumentException(obj + "(" + obj.getClass() + ")");
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        Object a = this.floatType.getValue(buf, settings, length / 2);
        WrappedMemBuffer wrp = new WrappedMemBuffer(buf, length / 2);
        Object b = this.floatType.getValue(wrp, settings, length / 2);
        return new Complex(AbstractComplexDataType.toDouble(a), AbstractComplexDataType.toDouble(b));
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Object val = this.getValue(buf, settings, length);
        if (val == null) {
            return "??";
        }
        return val.toString();
    }
}

