/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressObjectMap;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockImpl;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.ExtCodeBlockImpl;
import ghidra.program.model.block.SimpleBlockIterator;
import ghidra.program.model.block.SimpleDestReferenceIterator;
import ghidra.program.model.block.SimpleSourceReferenceIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class SimpleBlockModel
implements CodeBlockModel {
    public static final String NAME = "Simple Block";
    protected static final CodeBlock[] emptyArray = new CodeBlock[0];
    protected Program program;
    protected Listing listing;
    protected ReferenceManager referenceMgr;
    protected AddressObjectMap foundBlockMap;
    protected final boolean includeExternals;
    protected static final boolean followIndirectFlows = true;

    public SimpleBlockModel(Program program) {
        this(program, false);
    }

    public SimpleBlockModel(Program program, boolean includeExternals) {
        this.program = program;
        this.includeExternals = includeExternals;
        this.listing = program.getListing();
        this.referenceMgr = program.getReferenceManager();
        this.foundBlockMap = new AddressObjectMap();
    }

    @Override
    public CodeBlock getCodeBlockAt(Address addr, TaskMonitor monitor) throws CancelledException {
        Object[] blocks = this.foundBlockMap.getObjects(addr);
        if (blocks.length > 0) {
            Address[] entryPts;
            CodeBlock block = (CodeBlock)blocks[0];
            for (Address entryPt : entryPts = block.getStartAddresses()) {
                if (!block.getFirstStartAddress().equals(addr)) continue;
                return block;
            }
        }
        if (addr.isExternalAddress()) {
            return this.includeExternals ? this.createSimpleExtBlock(addr) : null;
        }
        Instruction instr = this.listing.getInstructionAt(addr);
        if (instr != null) {
            if (this.isBlockStart(instr)) {
                return this.getCodeBlockAt(instr, monitor);
            }
            if (instr.getSymbols().length != 0) {
                return this.getFirstCodeBlockContaining(addr, monitor);
            }
            return null;
        }
        Data data = this.listing.getDefinedDataAt(addr);
        if (data != null) {
            return this.createSimpleDataBlock(addr, data.getMaxAddress());
        }
        return null;
    }

    private CodeBlock getCodeBlockAt(Instruction instr, TaskMonitor monitor) throws CancelledException {
        Address begin = instr.getMinAddress();
        Address end = instr.getMaxAddress();
        ArrayList<Address> additionalEntryPts = new ArrayList<Address>();
        SymbolTable symTable = this.program.getSymbolTable();
        while (instr.hasFallthrough() && !this.hasEndOfBlockFlow(instr)) {
            Instruction nextInstr;
            if (monitor != null && monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address fallThru = instr.getFallThrough();
            if (fallThru == null || (nextInstr = this.listing.getInstructionAt(fallThru)) == null || symTable.hasSymbol(fallThru)) break;
            instr = nextInstr;
            end = instr.getMaxAddress();
        }
        Address exitPt = instr.getMinAddress();
        int slotCnt = instr.getDelaySlotDepth();
        if (slotCnt != 0) {
            while (slotCnt > 0 && (instr = instr.getNext()) != null) {
                --slotCnt;
                end = instr.getMaxAddress();
                Address addr = instr.getMinAddress();
                if (!symTable.hasSymbol(addr)) continue;
                additionalEntryPts.add(addr);
            }
        } else {
            try {
                Symbol sym;
                Address addr;
                Address chkAddr = exitPt.addNoWrap(1L);
                SymbolIterator iter = symTable.getSymbolIterator(chkAddr, true);
                while (iter.hasNext() && (addr = (sym = iter.next()).getAddress()).compareTo(end) <= 0) {
                    Instruction ocInstr = this.listing.getInstructionAt(addr);
                    if (ocInstr == null || ocInstr.getMaxAddress().compareTo(end) <= 0) continue;
                    additionalEntryPts.add(addr);
                    end = ocInstr.getMaxAddress();
                }
            }
            catch (AddressOverflowException chkAddr) {
                // empty catch block
            }
        }
        int cnt = additionalEntryPts.size();
        Address[] entryPts = new Address[cnt + 1];
        entryPts[0] = begin;
        for (int i = 0; i < cnt; ++i) {
            entryPts[i + 1] = (Address)additionalEntryPts.get(i);
        }
        return this.createSimpleBlock(entryPts, begin, end);
    }

    protected boolean hasEndOfBlockFlow(Instruction instr) {
        if (instr.getFlowType() != RefType.FALL_THROUGH) {
            return true;
        }
        return this.referenceMgr.hasFlowReferencesFrom(instr.getMinAddress());
    }

    protected CodeBlock createSimpleDataBlock(Address start, Address end) {
        return this.createSimpleBlock(new Address[]{start}, start, end);
    }

    private CodeBlock createSimpleBlock(Address[] entryPts, Address begin, Address end) {
        CodeBlockImpl block = new CodeBlockImpl(this, entryPts, new AddressSet(begin, end));
        this.foundBlockMap.addObject(block, begin, end);
        return block;
    }

    private CodeBlock createSimpleExtBlock(Address extAddr) {
        ExtCodeBlockImpl block = new ExtCodeBlockImpl(this, extAddr);
        this.foundBlockMap.addObject(block, extAddr, extAddr);
        return block;
    }

    @Override
    public CodeBlock[] getCodeBlocksContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock block = this.getFirstCodeBlockContaining(addr, monitor);
        if (block == null) {
            return emptyArray;
        }
        CodeBlock[] arr = new CodeBlock[]{block};
        return arr;
    }

    @Override
    public CodeBlock getFirstCodeBlockContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        if (addr == null) {
            return null;
        }
        Object[] blocks = this.foundBlockMap.getObjects(addr);
        if (blocks.length > 0) {
            return (CodeBlock)blocks[0];
        }
        if (addr.isExternalAddress()) {
            return this.getCodeBlockAt(addr, monitor);
        }
        Instruction instr = this.listing.getInstructionContaining(addr);
        if (instr != null) {
            Address fallFrom = instr.getFallFrom();
            while (!this.isBlockStart(instr, fallFrom)) {
                if (monitor != null && monitor.isCancelled()) {
                    throw new CancelledException();
                }
                if (fallFrom == null) {
                    Msg.warn((Object)this, (Object)("WARNING: Invalid delay slot or offcut instruction found at " + instr.getMinAddress()));
                    try {
                        fallFrom = instr.getMinAddress().subtractNoWrap(1L);
                    }
                    catch (AddressOverflowException e) {
                        break;
                    }
                }
                instr = this.listing.getInstructionContaining(fallFrom);
                fallFrom = instr.getFallFrom();
            }
            return this.getCodeBlockAt(instr, monitor);
        }
        Data data = this.listing.getDefinedDataContaining(addr);
        if (data != null) {
            return this.getCodeBlockAt(data.getMinAddress(), monitor);
        }
        return null;
    }

    @Override
    public CodeBlockIterator getCodeBlocks(TaskMonitor monitor) throws CancelledException {
        return new SimpleBlockIterator(this, monitor);
    }

    @Override
    public CodeBlockIterator getCodeBlocksContaining(AddressSetView addrSet, TaskMonitor monitor) throws CancelledException {
        return new SimpleBlockIterator(this, addrSet, monitor);
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    protected Listing getListing() {
        return this.listing;
    }

    protected boolean isBlockStart(Address addr) {
        CodeBlock block;
        Object[] blocks = this.foundBlockMap.getObjects(addr);
        if (blocks.length > 0 && (block = (CodeBlock)blocks[0]).getFirstStartAddress().equals(addr)) {
            return true;
        }
        Instruction instr = this.listing.getInstructionAt(addr);
        if (instr != null) {
            return this.isBlockStart(instr);
        }
        Data data = this.listing.getDefinedDataAt(addr);
        return data != null;
    }

    public boolean isBlockStart(Instruction instruction) {
        Address a = instruction.getFallFrom();
        return this.isBlockStart(instruction, a);
    }

    private boolean isBlockStart(Instruction instruction, Address fallFrom) {
        if (fallFrom == null) {
            try {
                Address addr = instruction.getMinAddress();
                Instruction chkInstr = this.listing.getInstructionContaining(addr.subtractNoWrap(1L));
                if (chkInstr != null && chkInstr.getMaxAddress().compareTo(addr) >= 0) {
                    return false;
                }
            }
            catch (AddressOverflowException addr) {
                // empty catch block
            }
            return true;
        }
        Instruction previous = this.listing.getInstructionContaining(fallFrom);
        if (previous == null) {
            return true;
        }
        if (instruction == null || instruction.isInDelaySlot()) {
            return false;
        }
        try {
            Address addr = previous.getMinAddress();
            Instruction chkInstr = this.listing.getInstructionContaining(addr.subtractNoWrap(1L));
            if (chkInstr != null && chkInstr.getMaxAddress().compareTo(addr) >= 0) {
                return true;
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        if (this.program.getSymbolTable().hasSymbol(instruction.getMinAddress())) {
            return true;
        }
        return !previous.hasFallthrough() || this.hasEndOfBlockFlow(previous);
    }

    @Override
    public String getName(CodeBlock block) {
        if (!(block.getModel() instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        Address start = block.getFirstStartAddress();
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(start);
        if (symbol != null) {
            return symbol.getName();
        }
        return start.toString();
    }

    @Override
    public FlowType getFlowType(CodeBlock block) {
        block6: {
            FlowType flowType;
            block9: {
                Instruction instr;
                block7: {
                    block10: {
                        block8: {
                            if (!(block.getModel() instanceof SimpleBlockModel)) {
                                throw new IllegalArgumentException();
                            }
                            instr = this.listing.getInstructionContaining(block.getMaxAddress());
                            if (instr == null) break block6;
                            while (instr.isInDelaySlot()) {
                                Address fallFrom = instr.getFallFrom();
                                if (fallFrom == null) {
                                    Msg.warn((Object)this, (Object)("WARNING: Invalid delay slot instruction found at " + instr.getMinAddress()));
                                    break;
                                }
                                instr = this.listing.getInstructionContaining(fallFrom);
                            }
                            flowType = instr.getFlowType();
                            if (block.getStartAddresses().length <= 1) break block7;
                            if (flowType != RefType.UNCONDITIONAL_CALL) break block8;
                            flowType = RefType.CONDITIONAL_CALL;
                            break block9;
                        }
                        if (flowType != RefType.UNCONDITIONAL_JUMP) break block10;
                        flowType = RefType.CONDITIONAL_JUMP;
                        break block9;
                    }
                    if (!flowType.isTerminal()) break block9;
                    flowType = RefType.CONDITIONAL_TERMINATOR;
                    break block9;
                }
                if (flowType.isFallthrough()) {
                    Reference[] refs;
                    for (Reference ref : refs = this.referenceMgr.getFlowReferencesFrom(instr.getMinAddress())) {
                        RefType refType = ref.getReferenceType();
                        if (!(refType instanceof FlowType)) continue;
                        flowType = (FlowType)refType;
                        break;
                    }
                }
            }
            return flowType;
        }
        Data data = this.listing.getDefinedDataContaining(block.getMinAddress());
        if (data != null) {
            return RefType.INDIRECTION;
        }
        return RefType.INVALID;
    }

    @Override
    public CodeBlockReferenceIterator getSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (block == null) {
            return null;
        }
        if (!(block.getModel() instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        return new SimpleSourceReferenceIterator(block, true, monitor);
    }

    @Override
    @Deprecated
    public int getNumSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (block == null) {
            return 0;
        }
        if (!(block.getModel() instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        return SimpleSourceReferenceIterator.getNumSources(block, true, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (block == null) {
            return null;
        }
        if (!(block.getModel() instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        return new SimpleDestReferenceIterator(block, true, monitor);
    }

    @Override
    @Deprecated
    public int getNumDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (block == null) {
            return 0;
        }
        if (!(block.getModel() instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        return SimpleDestReferenceIterator.getNumDestinations(block, true, monitor);
    }

    @Override
    public CodeBlockModel getBasicBlockModel() {
        return this;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean allowsBlockOverlap() {
        return false;
    }

    @Override
    public boolean externalsIncluded() {
        return this.includeExternals;
    }
}

