/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import ghidra.program.model.listing.Program;

public class ProgramTransaction
implements AutoCloseable {
    protected Program program;
    protected int tid;
    protected boolean commit = false;

    public static ProgramTransaction open(Program program, String description) {
        int tid = program.startTransaction(description);
        return new ProgramTransaction(program, tid);
    }

    private ProgramTransaction(Program program, int tid) {
        this.program = program;
        this.tid = tid;
    }

    @Override
    public void close() {
        this.program.endTransaction(this.tid, this.commit);
    }

    public void commit() {
        this.commit = true;
    }
}

