/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;

public class CodeSymbol
extends SymbolDB {
    public CodeSymbol(SymbolManager mgr, DBObjectCache<SymbolDB> cache, Address addr, DBRecord record) {
        super(mgr, cache, addr, record);
    }

    public CodeSymbol(SymbolManager mgr, DBObjectCache<SymbolDB> cache, Address addr, long key) {
        super(mgr, cache, addr, key);
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.LABEL;
    }

    @Override
    protected boolean refresh(DBRecord rec) {
        if (!this.isDynamic()) {
            return super.refresh(rec);
        }
        if (rec != null) {
            return false;
        }
        this.address = this.symbolMgr.getDynamicAddress(this.key);
        return this.symbolMgr.hasDynamicSymbol(this.address);
    }

    @Override
    public boolean isExternal() {
        return this.address.isExternalAddress();
    }

    @Override
    public boolean delete() {
        boolean keepReferences = !this.isExternal();
        return this.delete(keepReferences);
    }

    public boolean delete(boolean keepReferences) {
        this.lock.acquire();
        try {
            if (!keepReferences) {
                this.symbolMgr.getReferenceManager().removeAllReferencesTo(this.getAddress());
            }
            boolean bl = super.delete();
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isPinned() {
        if (!this.isExternal()) {
            return this.doIsPinned();
        }
        return false;
    }

    @Override
    public void setPinned(boolean pinned) {
        if (!this.isExternal()) {
            this.doSetPinned(pinned);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        this.lock.acquire();
        try {
            if (!this.checkIsValid()) {
                Object var1_1 = null;
                return var1_1;
            }
            if (this.isExternal()) {
                ExternalLocation externalLocation = this.symbolMgr.getExternalManager().getExternalLocation(this);
                return externalLocation;
            }
            CodeUnit cu = this.symbolMgr.getCodeManager().getCodeUnitContaining(this.address);
            if (cu != null) {
                if (this.address.equals(cu.getMinAddress())) {
                    CodeUnit codeUnit = cu;
                    return codeUnit;
                }
                if (cu instanceof Data) {
                    Data data = (Data)cu;
                    CodeUnit codeUnit = (data = data.getPrimitiveAt((int)this.address.subtract(data.getMinAddress()))) != null ? data : cu;
                    return codeUnit;
                }
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public boolean isPrimary() {
        if (this.getSource() == SourceType.DEFAULT || this.isExternal()) {
            return true;
        }
        return this.doCheckIsPrimary();
    }

    @Override
    public boolean setPrimary() {
        this.lock.acquire();
        try {
            if (this.address.isExternalAddress()) {
                boolean bl = false;
                return bl;
            }
            SymbolDB oldPrimarySymbol = null;
            this.checkDeleted();
            if (this.isPrimary()) {
                boolean bl = false;
                return bl;
            }
            oldPrimarySymbol = (SymbolDB)this.symbolMgr.getPrimarySymbol(this.address);
            if (oldPrimarySymbol != null) {
                if (oldPrimarySymbol instanceof FunctionSymbol) {
                    boolean bl = false;
                    return bl;
                }
                if (oldPrimarySymbol instanceof CodeSymbol) {
                    ((CodeSymbol)oldPrimarySymbol).setPrimary(false);
                }
            }
            this.setPrimary(true);
            this.symbolMgr.primarySymbolSet(this, oldPrimarySymbol);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    void setPrimary(boolean primary) {
        this.doSetPrimary(primary);
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return new LabelFieldLocation(this);
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return SymbolType.LABEL.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }

    @Override
    protected String doGetName() {
        if (this.getSource() == SourceType.DEFAULT && this.isExternal()) {
            return ExternalManagerDB.getDefaultExternalName(this);
        }
        return super.doGetName();
    }

    @Override
    protected SourceType validateNameSource(String newName, SourceType source) {
        if (!this.isExternal()) {
            if (source == SourceType.DEFAULT) {
                return SourceType.ANALYSIS;
            }
            return source;
        }
        if (newName == null || newName.length() == 0 || SymbolUtilities.isReservedDynamicLabelName(newName, this.symbolMgr.getProgram().getAddressFactory())) {
            return SourceType.DEFAULT;
        }
        return source;
    }
}

