/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.bookmark.BookmarkDBAdapter;
import ghidra.program.database.bookmark.OldBookmark;
import ghidra.program.database.bookmark.OldBookmarkManager;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class BookmarkDBAdapterV0
extends BookmarkDBAdapter {
    private DBHandle tmpHandle;
    private BookmarkDBAdapter conversionAdapter;

    BookmarkDBAdapterV0(DBHandle dbHandle) {
    }

    void setOldBookmarkManager(OldBookmarkManager oldMgr, AddressMap addrMap, TaskMonitor monitor) throws IOException {
        this.tmpHandle = new DBHandle();
        try {
            this.conversionAdapter = BookmarkDBAdapter.getAdapter(this.tmpHandle, 0, new int[0], addrMap, monitor);
        }
        catch (VersionException e) {
            throw new AssertException();
        }
        DBRecord[] oldTypes = oldMgr.getTypeRecords();
        if (oldTypes.length == 0) {
            return;
        }
        monitor.setMessage("Translating Old Bookmarks...");
        int max = 0;
        for (int i = 0; i < oldTypes.length; ++i) {
            max += oldMgr.getBookmarkCount(oldTypes[i].getString(0));
        }
        monitor.initialize((long)max);
        int cnt = 0;
        for (int i = 0; i < oldTypes.length; ++i) {
            String type = oldTypes[i].getString(0);
            int typeId = (int)oldTypes[i].getKey();
            this.conversionAdapter.addType(typeId);
            AddressIterator iter = oldMgr.getBookmarkAddresses(type);
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new IOException("Upgrade Cancelled");
                }
                Address addr = iter.next();
                OldBookmark bm = oldMgr.getBookmark(addr, type);
                this.conversionAdapter.createBookmark(typeId, bm.getCategory(), addrMap.getKey(addr, true), bm.getComment());
                monitor.setProgress((long)(++cnt));
            }
        }
    }

    @Override
    DBRecord getRecord(long id) throws IOException {
        return this.conversionAdapter.getRecord(id);
    }

    @Override
    RecordIterator getRecordsByTypeAndCategory(int typeId, String category) throws IOException {
        return this.conversionAdapter.getRecordsByTypeAndCategory(typeId, category);
    }

    @Override
    RecordIterator getRecordsByType(int typeId) throws IOException {
        return this.conversionAdapter.getRecordsByType(typeId);
    }

    @Override
    String[] getCategories(int typeId) throws IOException {
        return this.conversionAdapter.getCategories(typeId);
    }

    @Override
    AddressSetView getBookmarkAddresses(int typeId) throws IOException {
        return this.conversionAdapter.getBookmarkAddresses(typeId);
    }

    protected void finalize() throws Throwable {
        if (this.tmpHandle != null) {
            this.tmpHandle.close();
            this.tmpHandle = null;
        }
    }

    @Override
    int getBookmarkCount(int typeId) {
        return this.conversionAdapter.getBookmarkCount(typeId);
    }

    @Override
    int getBookmarkCount() {
        return this.conversionAdapter.getBookmarkCount();
    }

    @Override
    RecordIterator getRecordsByTypeAtAddress(int typeId, long address) throws IOException {
        return this.conversionAdapter.getRecordsByTypeAtAddress(typeId, address);
    }

    @Override
    RecordIterator getRecordsByTypeStartingAtAddress(int typeID, long startAddress, boolean forward) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getRecordsByTypeForAddressRange(int typeId, long startAddr, long endAddr) throws IOException {
        return this.conversionAdapter.getRecordsByTypeForAddressRange(typeId, startAddr, endAddr);
    }
}

