/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.pcoderaw;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.address.AddressUtils;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.translate.Translate;
import org.jdom.Element;

public class VarnodeData {
    public AddrSpace space;
    public long offset;
    public int size;

    public VarnodeData() {
    }

    public VarnodeData(AddrSpace base, long off, int size) {
        this.space = base;
        this.offset = off;
        this.size = size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != VarnodeData.class) {
            return false;
        }
        VarnodeData other = (VarnodeData)obj;
        return this.space == other.space && this.offset == other.offset && this.size == other.size;
    }

    public int hashCode() {
        return this.space.hashCode() + (int)this.offset + this.size;
    }

    public int compareTo(VarnodeData other) {
        int result = this.space.compareTo(other.space);
        if (result != 0) {
            return result;
        }
        result = AddressUtils.unsignedCompare(this.offset, other.offset);
        if (result != 0) {
            return result;
        }
        return other.size - this.size;
    }

    public void restoreXml(Element el, Translate trans) {
        String name = el.getAttributeValue("name");
        if (name != null) {
            VarnodeData vdata = trans.getRegister(name);
            this.space = vdata.space;
            this.offset = vdata.offset;
            this.size = vdata.size;
            return;
        }
        String attributeValue = el.getAttributeValue("space");
        if (attributeValue == null) {
            return;
        }
        this.space = trans.getSpaceByName(attributeValue);
        if (this.space == null) {
            throw new LowlevelError("Unknown space name: " + attributeValue);
        }
        this.offset = AddrSpace.restore_xml_offset(el);
        this.size = AddrSpace.restore_xml_size(el);
    }

    public Address getAddress() {
        return new Address(this.space, this.offset);
    }
}

