/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import java.util.Arrays;

public class StringChoices {
    protected String[] values;
    protected int selected;

    public StringChoices(String[] values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("Set of values must contain at least one value");
        }
        this.values = values;
        this.selected = 0;
    }

    public StringChoices(StringChoices strEnum) {
        if (strEnum == null) {
            throw new IllegalArgumentException("Set of values must contain at least one value");
        }
        this.values = (String[])strEnum.values.clone();
        this.selected = strEnum.selected;
    }

    public String[] getValues() {
        String[] copy = new String[this.values.length];
        System.arraycopy(this.values, 0, copy, 0, this.values.length);
        return copy;
    }

    public String getSelectedValue() {
        return this.values[this.selected];
    }

    public int getSelectedValueIndex() {
        return this.selected;
    }

    public boolean contains(String value) {
        return this.indexOf(value) != -1;
    }

    public int indexOf(String value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedValue(String value) {
        int index = this.indexOf(value);
        if (index == -1) {
            throw new IllegalArgumentException("No such value in Enum");
        }
        this.selected = index;
    }

    public void setSelectedValue(int index) {
        if (index < 0 || index >= this.values.length) {
            throw new IllegalArgumentException("index out of range");
        }
        this.selected = index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.selected;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringChoices other = (StringChoices)obj;
        if (this.selected != other.selected) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public String toString() {
        return this.getSelectedValue();
    }
}

