/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.annotations;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.annotations.AnnotatingGraphMousePlugin;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.DefaultModalGraphMouse;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.RotatingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.modal.Modal;

public class AnnotatingModalGraphMouse<V, E>
extends DefaultModalGraphMouse<V, E>
implements ModalGraphMouse {
    protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public AnnotatingModalGraphMouse() {
        this(new Builder());
    }

    protected AnnotatingModalGraphMouse(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.basicTransformer = builder.multiLayerTransformerSupplier.get();
        this.annotatingPlugin = builder.annotatingPlugin;
    }

    @Override
    public void loadPlugins() {
        this.selectingPlugin = ((SelectingGraphMousePlugin.Builder)((SelectingGraphMousePlugin.Builder)SelectingGraphMousePlugin.builder().singleSelectionMask(1024)).toggleSingleSelectionMask(1088)).build();
        this.regionSelectingPlugin = ((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)RegionSelectingGraphMousePlugin.builder().regionSelectionMask(1024)).toggleRegionSelectionMask(1088)).regionSelectionCompleteMask(0)).toggleRegionSelectionCompleteMask(64)).build();
        this.translatingPlugin = ((TranslatingGraphMousePlugin.Builder)TranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
        this.scalingPlugin = ScalingGraphMousePlugin.builder().scalingControl(new CrossoverScalingControl()).build();
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.setMode(this.mode);
    }

    @Override
    public void setMode(Modal.Mode mode) {
        this.mode = mode;
        if (mode == Modal.Mode.TRANSFORMING) {
            this.setTransformingMode();
        } else if (mode == Modal.Mode.PICKING) {
            this.setPickingMode();
        } else if (mode == Modal.Mode.ANNOTATING) {
            this.setAnnotatingMode();
        }
    }

    @Override
    protected void setPickingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.selectingPlugin);
        this.add(this.regionSelectingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    protected void setAnnotatingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.annotatingPlugin);
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, char a, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(Modal.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(Modal.Mode.PICKING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(Modal.Mode.ANNOTATING);
            }
        }
    }

    public static class Builder<V, E, T extends AnnotatingModalGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends DefaultModalGraphMouse.Builder<V, E, T, B> {
        protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
        protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;

        public B multiLayerTransformerSupplier(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier) {
            this.multiLayerTransformerSupplier = multiLayerTransformerSupplier;
            return (B)((Builder)this.self());
        }

        public B annotatingPlugin(AnnotatingGraphMousePlugin<V, E> annotatingGraphMousePlugin) {
            this.annotatingPlugin = annotatingGraphMousePlugin;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new AnnotatingModalGraphMouse(this);
        }
    }
}

