/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import agent.gdb.pty.Pty;
import agent.gdb.pty.linux.LinuxPtyChild;
import agent.gdb.pty.linux.LinuxPtyParent;
import agent.gdb.pty.linux.Util;
import ghidra.util.Msg;
import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;

public class LinuxPty
implements Pty {
    static final POSIX LIB_POSIX = POSIXFactory.getNativePOSIX();
    private final int aparent;
    private final int achild;
    private boolean closed = false;
    private final LinuxPtyParent parent;
    private final LinuxPtyChild child;

    public static LinuxPty openpty() throws IOException {
        IntByReference p = new IntByReference();
        IntByReference c = new IntByReference();
        Pointer n = Pointer.wrap((Runtime)Runtime.getSystemRuntime(), (ByteBuffer)ByteBuffer.allocate(1024));
        if (Util.INSTANCE.openpty(p, c, n, null, null) < 0) {
            int errno = LIB_POSIX.errno();
            throw new IOException(errno + ": " + LIB_POSIX.strerror(errno));
        }
        return new LinuxPty(p.intValue(), c.intValue(), n.getString(0L));
    }

    LinuxPty(int aparent, int achild, String name) {
        Msg.debug((Object)this, (Object)("New Pty: " + name + " at (" + aparent + "," + achild + ")"));
        this.aparent = aparent;
        this.achild = achild;
        this.parent = new LinuxPtyParent(aparent);
        this.child = new LinuxPtyChild(achild, name);
    }

    @Override
    public LinuxPtyParent getParent() {
        return this.parent;
    }

    @Override
    public LinuxPtyChild getChild() {
        return this.child;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        int result = LIB_POSIX.close(this.achild);
        if (result < 0) {
            throw new IOException(LIB_POSIX.strerror(LIB_POSIX.errno()));
        }
        result = LIB_POSIX.close(this.aparent);
        if (result < 0) {
            throw new IOException(LIB_POSIX.strerror(LIB_POSIX.errno()));
        }
        this.closed = true;
    }
}

