/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbState;
import agent.gdb.manager.evt.GdbStoppedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;
import ghidra.util.Msg;

public class GdbInterruptCommand
extends AbstractGdbCommand<Void> {
    public GdbInterruptCommand(GdbManagerImpl manager) {
        super(manager);
    }

    @Override
    public boolean validInState(GdbState state) {
        return true;
    }

    @Override
    public String encode() {
        GdbManagerImpl.Interpreter i = this.getInterpreter();
        if (i == this.manager.getRunningInterpreter()) {
            Msg.debug((Object)this, (Object)("Using ^C to interrupt via " + i));
            return "\u0003";
        }
        switch (i) {
            case CLI: {
                Msg.debug((Object)this, (Object)"Interrupting via CLI");
                return "interrupt";
            }
            case MI2: {
                Msg.debug((Object)this, (Object)"Interrupting via MI2");
                return "-exec-interrupt";
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbStoppedEvent) {
            pending.claim(evt);
            return true;
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        return null;
    }

    @Override
    public GdbManagerImpl.Interpreter getInterpreter() {
        if (this.manager.hasCli() && this.manager.getRunningInterpreter() == GdbManagerImpl.Interpreter.MI2) {
            return GdbManagerImpl.Interpreter.CLI;
        }
        return GdbManagerImpl.Interpreter.MI2;
    }
}

