/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbBreakpointModifiedEvent;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;
import org.apache.commons.lang3.StringUtils;

public class GdbEnableBreakpointsCommand
extends AbstractGdbCommand<Void> {
    private final long[] numbers;

    public GdbEnableBreakpointsCommand(GdbManagerImpl manager, long ... numbers) {
        super(manager);
        this.numbers = numbers;
    }

    @Override
    public String encode() {
        return "-break-enable " + StringUtils.join((long[])this.numbers, (char)' ');
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbBreakpointModifiedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        for (long number : this.numbers) {
            this.manager.doBreakpointEnabled(number, pending);
        }
        return null;
    }
}

