/*
 * Decompiled with CFR 0.152.
 */
package resources;

import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.IconProvider;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.RotateIcon;
import resources.icons.TranslateIcon;

public class Icons {
    public static final ImageIcon EMPTY_ICON = Icons.get("images/EmptyIcon16.gif");
    public static final ImageIcon HELP_ICON = Icons.get("images/help-browser.png");
    public static final ImageIcon ADD_ICON = Icons.get("images/Plus2.png");
    public static final ImageIcon COLLAPSE_ALL_ICON = Icons.get("images/collapse_all.png");
    public static final ImageIcon EXPAND_ALL_ICON = Icons.get("images/expand_all.png");
    public static final ImageIcon CONFIGURE_FILTER_ICON = Icons.get("images/exec.png");
    public static final ImageIcon DELETE_ICON = Icons.get("images/error.png");
    public static final ImageIcon ERROR_ICON = Icons.get("images/emblem-important.png");
    public static final ImageIcon NAVIGATE_ON_INCOMING_EVENT_ICON = Icons.get("images/locationIn.gif");
    public static final ImageIcon NAVIGATE_ON_OUTGOING_EVENT_ICON = Icons.get("images/locationOut.gif");
    public static final ImageIcon NOT_ALLOWED_ICON = Icons.get("images/no.png");
    public static final ImageIcon OPEN_FOLDER_ICON = Icons.get("images/openSmallFolder.png");
    public static final ImageIcon REFRESH_ICON = Icons.get("images/reload3.png");
    public static final ImageIcon SORT_ASCENDING_ICON = Icons.get("images/sortascending.png");
    public static final ImageIcon SORT_DESCENDING_ICON = Icons.get("images/sortdescending.png");
    public static final ImageIcon STOP_ICON = Icons.get("images/process-stop.png");
    public static final ImageIcon STRONG_WARNING_ICON = Icons.get("images/software-update-urgent.png");
    public static final ImageIcon LEFT_ICON = Icons.get("images/left.png");
    public static final ImageIcon RIGHT_ICON = Icons.get("images/right.png");
    public static final ImageIcon LEFT_ALTERNATE_ICON = Icons.get("images/left.alternate.png");
    public static final ImageIcon RIGHT_ALTERNATE_ICON = Icons.get("images/right.alternate.png");
    public static final ImageIcon SAVE_AS = ResourceManager.getImageIcon(new DotDotDotIcon(Icons.get("images/Disk.png")));
    public static final ImageIcon MAKE_SELECTION_ICON = Icons.get("images/text_align_justify.png");
    public static final ImageIcon ARROW_DOWN_RIGHT_ICON = ResourceManager.getImageIcon(new RotateIcon(Icons.get("images/viewmagfit.png"), 90));
    public static final ImageIcon ARROW_UP_LEFT_ICON = ResourceManager.getImageIcon(new RotateIcon(Icons.get("images/viewmagfit.png"), 275));
    public static final ImageIcon FILTER_NOT_ACCEPTED_ICON = ResourceManager.getImageIcon(new MultiIcon((Icon)Icons.get("images/flag.png"), new TranslateIcon(ResourceManager.loadImage("images/dialog-cancel.png", 10, 10), 6, 6)));
    public static final ImageIcon APPLY_BLOCKED_MATCH_ICON = ResourceManager.getImageIcon(new MultiIcon((Icon)Icons.get("images/kgpg.png"), new TranslateIcon(ResourceManager.loadImage("images/checkmark_green.gif", 12, 12), 4, 0)));

    public static boolean isIconsReference(String snippet) {
        return snippet.startsWith(Icons.class.getSimpleName());
    }

    public static IconProvider getIconForIconsReference(String snippet) {
        String fieldName = Icons.getIconName(snippet);
        if (fieldName == null) {
            return null;
        }
        ImageIcon icon = Icons.getIconByFieldName(fieldName);
        if (icon == null) {
            return null;
        }
        URL url = Icons.getUrlFromIcon(icon);
        return new IconProvider(icon, url);
    }

    public static ImageIcon get(String iconPath) {
        return ResourceManager.loadImage(iconPath);
    }

    public static ImageIcon get(String iconPath, int width, int height) {
        return ResourceManager.loadImage(iconPath, width, height);
    }

    private static String getIconName(String snippet) {
        if (!Icons.isIconsReference(snippet)) {
            return null;
        }
        String fieldName = snippet.substring(Icons.class.getSimpleName().length() + 1);
        return fieldName;
    }

    private static ImageIcon getIconByFieldName(String fieldName) {
        try {
            Field field = Icons.class.getField(fieldName);
            ImageIcon icon = (ImageIcon)field.get(Icons.class);
            return icon;
        }
        catch (Exception e) {
            Msg.debug(Icons.class, (Object)("No icon named '" + fieldName + "' in class " + Icons.class.getName()));
            return null;
        }
    }

    private static URL getUrlFromIcon(ImageIcon icon) {
        if (icon == null) {
            return null;
        }
        String description = icon.getDescription();
        if (description == null) {
            Msg.debug(Icons.class, (Object)"Unable to get URL for icon - icon description is missing");
            return null;
        }
        try {
            URL url = new URL(description);
            return url;
        }
        catch (MalformedURLException e) {
            Msg.trace(Icons.class, (Object)("Unable to get URL for icon: " + description));
            return null;
        }
    }

    private Icons() {
    }

    private static class DotDotDotIcon
    implements Icon {
        private Icon base;

        public DotDotDotIcon(Icon base) {
            this.base = ResourceManager.getScaledIcon(base, 12, 12);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.base.paintIcon(c, g, x, y);
            g.setColor(new Color(50, 50, 50));
            g.fillRect(x + 6, y + 14, 2, 2);
            g.fillRect(x + 9, y + 14, 2, 2);
            g.fillRect(x + 12, y + 14, 2, 2);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

