/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.register.RegisterTypeInfo;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.util.ConversionUtils;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public interface DebuggerRegisterMapper {
    public TargetRegister getTargetRegister(String var1);

    public Register getTraceRegister(String var1);

    default public Map.Entry<String, byte[]> traceToTarget(RegisterValue registerValue) {
        Register lReg = registerValue.getRegister();
        if (!lReg.isBaseRegister()) {
            throw new IllegalArgumentException();
        }
        TargetRegister tReg = this.traceToTarget(lReg);
        if (tReg == null) {
            return null;
        }
        return Map.entry(tReg.getIndex(), ConversionUtils.bigIntegerToBytes((int)lReg.getMinimumByteSize(), (BigInteger)registerValue.getUnsignedValue()));
    }

    default public Map<String, byte[]> traceToTarget(Collection<RegisterValue> registerValues) {
        LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
        for (RegisterValue rv : registerValues) {
            Map.Entry<String, byte[]> entry = this.traceToTarget(rv);
            if (entry == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public TargetRegister traceToTarget(Register var1);

    default public RegisterValue targetToTrace(String tRegName, byte[] value) {
        TargetRegister tReg = this.getTargetRegister(tRegName);
        if (tReg == null) {
            return null;
        }
        return this.targetToTrace(tReg, value);
    }

    default public RegisterValue targetToTrace(TargetRegister tReg, byte[] value) {
        if (value == null) {
            return null;
        }
        Register lReg = this.targetToTrace(tReg);
        if (lReg == null) {
            return null;
        }
        BigInteger big = new BigInteger(1, value);
        return new RegisterValue(lReg, big);
    }

    default public Map<Register, RegisterValue> targetToTrace(Map<String, byte[]> values) {
        LinkedHashMap<Register, RegisterValue> result = new LinkedHashMap<Register, RegisterValue>();
        for (Map.Entry<String, byte[]> ent : values.entrySet()) {
            RegisterValue rv = this.targetToTrace(ent.getKey(), ent.getValue());
            if (rv == null) continue;
            result.put(rv.getRegister(), rv);
        }
        return result;
    }

    public Register targetToTrace(TargetRegister var1);

    public RegisterTypeInfo getDefaultTypeInfo(Register var1);

    public Set<Register> getRegistersOnTarget();

    public void targetRegisterAdded(TargetRegister var1);

    public void targetRegisterRemoved(TargetRegister var1);
}

