/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.htmlparser.jericho.CharStreamSource;

public final class CharStreamSourceUtil {
    private static final int DEFAULT_ESTIMATED_MAXIMUM_OUTPUT_LENGTH = 2048;

    private CharStreamSourceUtil() {
    }

    public static Reader getReader(CharStreamSource charStreamSource) {
        return new StringReader(CharStreamSourceUtil.toString(charStreamSource));
    }

    public static String toString(CharStreamSource charStreamSource) {
        long estimatedMaximumOutputLength = charStreamSource.getEstimatedMaximumOutputLength();
        if (estimatedMaximumOutputLength <= -1L) {
            estimatedMaximumOutputLength = 2048L;
        }
        StringBuilder sb = new StringBuilder((int)estimatedMaximumOutputLength);
        try {
            charStreamSource.appendTo(sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }
}

