/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.wizards.ITextExportPart;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;

public class OutlineTextExporter
extends Exporter {
    private boolean currentSheetOnly;
    private PrintStream ps;

    public OutlineTextExporter(ISheet sheet, ITopic centralTopic) {
        super(sheet, centralTopic);
    }

    public OutlineTextExporter(ISheet sheet, ITopic centralTopic, boolean currentSheetOnly) {
        super(sheet, centralTopic);
        this.currentSheetOnly = currentSheetOnly;
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    public boolean canStart() {
        return super.canStart() && this.ps != null;
    }

    public void init() {
        ISheet sheet = this.getSheet();
        if (this.currentSheetOnly) {
            this.append((IExportPart)new TitlePart((IExporter)this, sheet.getTitleText(), 0));
            this.appendTopicTitle(sheet.getRootTopic(), 1);
        } else {
            IWorkbook workbook = sheet.getOwnedWorkbook();
            String title = this.getWorkbooTitle(workbook);
            this.append((IExportPart)new TitlePart((IExporter)this, title, 0));
            for (ISheet s : workbook.getSheets()) {
                this.append((IExportPart)new TitlePart((IExporter)this, s.getTitleText(), 1));
                this.appendTopicTitle(s.getRootTopic(), 2);
            }
        }
    }

    private String getWorkbooTitle(IWorkbook workbook) {
        ISheet sheet;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        String name = null;
        if (window != null) {
            IEditorReference[] editorReferences = window.getActivePage().getEditorReferences();
            IEditorInput editorInput = MME.getEditorInputWithWorkbookAndEditors((IWorkbook)workbook, (IEditorReference[])editorReferences);
            name = editorInput.getName();
        }
        if (name == null && (sheet = workbook.getPrimarySheet()) != null) {
            name = sheet.getRootTopic().getTitleText();
        }
        return name;
    }

    private void appendTopicTitle(ITopic topic, int level) {
        this.append((IExportPart)new TitlePart((IExporter)this, topic.getTitleText(), level));
        List attacheds = topic.getChildren("attached");
        for (ITopic attached : attacheds) {
            this.appendTopicTitle(attached, level + 1);
        }
        List detacheds = topic.getChildren("detached");
        for (ITopic detached : detacheds) {
            this.appendTopicTitle(detached, level + 1);
        }
        List summaries = topic.getChildren("summary");
        for (ITopic summary : summaries) {
            this.appendTopicTitle(summary, level + 1);
        }
        List callouts = topic.getChildren("callout");
        for (ITopic callout : callouts) {
            this.appendTopicTitle(callout, level + 1);
        }
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (this.ps == null) {
            return;
        }
        if (part instanceof ITextExportPart) {
            ((ITextExportPart)part).write(this.ps);
        }
    }

    private static class TitlePart
    extends ExportPart
    implements ITextExportPart {
        private static final String INDENTATION = "\t";
        private int level;

        public TitlePart(IExporter exporter, Object element) {
            super(exporter, element);
        }

        public TitlePart(IExporter exporter, String element, int level) {
            super(exporter, (Object)element);
            this.level = level;
        }

        public void write(PrintStream ps) {
            String title = (String)this.getElement();
            ps.println(String.valueOf(this.getIndentation()) + this.trim(this.correctTitle(title)));
        }

        private String trim(String title) {
            int index = 0;
            int i = 0;
            while (i < title.length()) {
                if (title.charAt(i) != ' ') break;
                ++index;
                ++i;
            }
            return " " + title.substring(index);
        }

        private String getIndentation() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.level) {
                sb.append(INDENTATION);
                ++i;
            }
            return sb.toString();
        }

        private String correctTitle(String title) {
            return title.replaceAll("\r\n|\r|\n", " ");
        }
    }
}

