/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.ResourceRef;
import org.xmind.core.plain.Topic;
import org.xmind.core.plain.TopicExtensionElement;

public class TopicExtension
implements ITopicExtension {
    public static final String ResourceRefAdd = "resourceRefAdd";
    public static final String ResourceRefRemove = "resourceRefRemove";
    public static final String CONTENT_NAME = "content";
    private final Topic ownerTopic;
    private final String providerName;
    private boolean orphan;
    private TopicExtensionElement content;
    private List<ResourceRef> resourceRefs;

    public TopicExtension(Topic ownerTopic, String providerName) {
        this.ownerTopic = ownerTopic;
        this.providerName = providerName;
        this.orphan = true;
        this.content = new TopicExtensionElement(this, CONTENT_NAME);
        this.resourceRefs = new ArrayList<ResourceRef>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (ITopic.class.equals(adapter)) {
            return adapter.cast(this.getParent());
        }
        return null;
    }

    public ITopic getParent() {
        return this.ownerTopic;
    }

    public ISheet getOwnedSheet() {
        return this.ownerTopic.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerTopic.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public ITopicExtensionElement getContent() {
        return this.content;
    }

    public List<IResourceRef> getResourceRefs() {
        return Collections.unmodifiableList(this.resourceRefs);
    }

    public void addResourceRef(IResourceRef ref) {
        if (ref == null || !(ref instanceof ResourceRef) || ref.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        ResourceRef r = (ResourceRef)ref;
        if (this.resourceRefs.add(r)) {
            if (!this.isOrphan()) {
                r.onParented();
            }
            this.ownerTopic.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this.ownerTopic, ResourceRefAdd, (Object)r);
        }
    }

    public void removeResourceRef(IResourceRef ref) {
        if (ref == null || !(ref instanceof ResourceRef) || ref.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        ResourceRef r = (ResourceRef)ref;
        if (this.resourceRefs.contains(r)) {
            if (!this.isOrphan()) {
                r.onOrphan();
            }
            this.resourceRefs.remove(r);
            this.ownerTopic.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this.ownerTopic, ResourceRefRemove, (Object)r);
        }
    }

    protected void onParented() {
        this.orphan = false;
        this.content.onParented();
        for (ResourceRef r : this.resourceRefs) {
            r.onParented();
        }
    }

    protected void onOrphan() {
        for (ResourceRef r : this.resourceRefs) {
            r.onOrphan();
        }
        this.content.onOrphan();
        this.orphan = true;
    }
}

