/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.internal.spelling.SpellCheckerRegistry;

public class SpellingPlugin
extends AbstractUIPlugin {
    public static final String SPELLING_CHECK_ENABLED = "SPELLING_CHECK_ENABLED";
    public static final String DEFAULT_SPELLING_CHECKER_INVISIBLE = "DEFAULT_SPELLING_CHECKER_INVISIBLE";
    public static final String DEFAULT_SPELLING_CHECKER_DISABLED = "DEFAULT_SPELLING_CHECKER_DISABLED";
    public static final String HIDE_SPELLING_CHECK_PROGRESS = "HIDE_SPELLING_CHECK_PROGRESS";
    public static final String SPELLING_CHECK_VIEW_ID = "org.xmind.ui.SpellingCheckView";
    public static final String PLUGIN_ID = "org.xmind.ui.spelling";
    private static SpellingPlugin plugin;
    private ServiceTracker<IUsageDataSampler, IUsageDataSampler> usageDataTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.usageDataTracker = new ServiceTracker(context, IUsageDataSampler.class, null);
        this.usageDataTracker.open();
        SpellCheckerAgent.migrateUserDictFile();
        SpellCheckerRegistry.migrateUserDictDir();
    }

    public void stop(BundleContext context) throws Exception {
        this.usageDataTracker.close();
        this.usageDataTracker = null;
        plugin = null;
        super.stop(context);
    }

    public IUsageDataSampler getUsageDataCollector() {
        IUsageDataSampler service = this.usageDataTracker == null ? null : (IUsageDataSampler)this.usageDataTracker.getService();
        return service == null ? IUsageDataSampler.NULL : service;
    }

    public static SpellingPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        SpellingPlugin.log(e, "");
    }

    public static void log(Throwable e, String message) {
        SpellingPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static boolean isSpellingCheckEnabled() {
        return SpellingPlugin.getDefault().getPreferenceStore().getBoolean(SPELLING_CHECK_ENABLED);
    }

    public static String getBundleDataPath(String subPath) {
        IPath stateLocation = SpellingPlugin.getDefault().getStateLocation();
        return stateLocation.append(subPath).makeAbsolute().toOSString();
    }
}

