/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.util.MindMapUtils;

public class MindMapState {
    private static final String TAG_STATES = "states";
    private static final String TAG_WORKBOOK = "workbook";
    private static final String TAG_SHEET = "sheet";
    private static final String TAG_STATE_ZOOM = "zoom";
    private static final String STATE_FILE = "/state.xml";
    private static final String ZOOM_VALUE = "zoom-value";
    private static final int NEGATIVE_INDEX = -1;
    private static volatile MindMapState instance;
    private static final int MAX_STATE_NUM = 100;
    private File stateFile;
    private XMLMemento root;

    private MindMapState() {
        this.init();
    }

    private void init() {
        if (this.root == null) {
            this.root = this.getRootMemento();
        }
    }

    public void saveState(IWorkbookRef workbookRef, IGraphicalEditorPage[] pages) {
        if (workbookRef != null) {
            IWorkbook workbook = workbookRef.getWorkbook();
            URI uri = workbookRef.getURI();
            if (workbook != null && uri != null && pages != null && pages.length != 0) {
                IGraphicalEditorPage[] iGraphicalEditorPageArray = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
                    this.writeState(page, uri);
                    ++n2;
                }
            }
        }
    }

    private void writeState(IGraphicalEditorPage page, URI uri) {
        try {
            IMemento workbookMem;
            ISheet sheet = MindMapUtils.findSheet(page);
            int workbookIndex = this.getWorkbookIndex(this.root.getChildren(TAG_WORKBOOK), uri.toString());
            if (workbookIndex != -1) {
                workbookMem = this.root.getChildren(TAG_WORKBOOK)[workbookIndex];
                int index = this.getSheetIndex(workbookMem.getChildren(TAG_SHEET), sheet.getId());
                if (index != -1) {
                    IMemento sheetMem = workbookMem.getChildren(TAG_SHEET)[index];
                    IMemento zoomMem = sheetMem.getChild(TAG_STATE_ZOOM);
                    this.setZoomValue(page, zoomMem);
                } else {
                    IMemento zoomMem = this.createZoomMem(sheet, workbookMem);
                    this.setZoomValue(page, zoomMem);
                }
            } else {
                if (this.root.getChildren(TAG_WORKBOOK).length >= 100) {
                    this.removeOldestState();
                }
                workbookMem = this.root.createChild(TAG_WORKBOOK, uri.toString());
                IMemento zoomMem = this.createZoomMem(sheet, workbookMem);
                this.setZoomValue(page, zoomMem);
            }
            File sf = this.getStateFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sf), "utf-8"), 1024);
            try {
                this.root.save((Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Exception exception) {}
    }

    private void removeOldestState() {
        try {
            Field eleField = this.root.getClass().getDeclaredField("element");
            boolean isAccessible = eleField.isAccessible();
            eleField.setAccessible(true);
            Element element = (Element)eleField.get(this.root);
            NodeList list = element.getElementsByTagName(TAG_WORKBOOK);
            if (list != null && list.getLength() > 0) {
                Node firstWorkbookNode = list.item(0);
                element.removeChild(firstWorkbookNode);
            }
            eleField.setAccessible(isAccessible);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private IMemento createZoomMem(ISheet sheet, IMemento workbookMem) {
        IMemento sheetMem = workbookMem.createChild(TAG_SHEET, sheet.getId());
        IMemento zoomMem = sheetMem.createChild(TAG_STATE_ZOOM);
        return zoomMem;
    }

    private void setZoomValue(IGraphicalEditorPage page, IMemento zoomMem) {
        zoomMem.putFloat(ZOOM_VALUE, (float)page.getViewer().getZoomManager().getScale());
    }

    public void loadState(IWorkbookRef workbookRef, IGraphicalEditorPage page) {
        int zoom;
        IMemento workbookMem;
        int index;
        URI uri = workbookRef.getURI();
        if (uri == null) {
            return;
        }
        ISheet sheet = MindMapUtils.findSheet(page);
        boolean hasZoom = false;
        int workbookIndex = this.getWorkbookIndex(this.root.getChildren(), uri.toString());
        if (workbookIndex != -1 && (index = this.getSheetIndex((workbookMem = this.root.getChildren(TAG_WORKBOOK)[workbookIndex]).getChildren(TAG_SHEET), sheet.getId())) != -1) {
            hasZoom = true;
            IMemento sheetMem = workbookMem.getChildren(TAG_SHEET)[index];
            IMemento zoomMem = sheetMem.getChild(TAG_STATE_ZOOM);
            Float zoom2 = zoomMem.getFloat(ZOOM_VALUE);
            page.getViewer().getZoomManager().setScale((double)zoom2.floatValue());
        }
        if (!hasZoom && (zoom = MindMapUIPlugin.getDefault().getPreferenceStore().getInt("zoome_value")) != 0) {
            page.getViewer().getZoomManager().setScale((double)zoom / 100.0);
            hasZoom = true;
        }
        if (!hasZoom) {
            int width = Display.getCurrent().getBounds().width;
            if (1366 <= width && width <= 1920) {
                page.getViewer().getZoomManager().setScale(1.2);
            } else if (width > 1920) {
                page.getViewer().getZoomManager().setScale(1.5);
            }
        }
    }

    private File getStateFile() {
        if (this.stateFile == null) {
            this.stateFile = new File(MindMapUIPlugin.getDefault().getStateLocation().toFile(), STATE_FILE);
        }
        return this.stateFile;
    }

    private int getSheetIndex(IMemento[] children, String id) {
        int index = 0;
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mem = iMementoArray[n2];
            if (id.equals(mem.getID())) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private int getWorkbookIndex(IMemento[] children, String file) {
        int index = 0;
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mem = iMementoArray[n2];
            if (mem.getID().equals(file)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private XMLMemento getRootMemento() {
        XMLMemento memento;
        block15: {
            memento = null;
            InputStreamReader reader = null;
            try {
                try {
                    File sf = this.getStateFile();
                    reader = new InputStreamReader((InputStream)new FileInputStream(sf), "utf-8");
                    memento = XMLMemento.createReadRoot((Reader)reader);
                }
                catch (Exception exception) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)TAG_STATES);
        }
        return memento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MindMapState getInstance() {
        if (instance != null) return instance;
        Class<MindMapState> clazz = MindMapState.class;
        synchronized (MindMapState.class) {
            if (instance != null) return instance;
            instance = new MindMapState();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

