/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.makers;

import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.makers.ThumbnailMaker;

public final class FixedSizeThumbnailMaker
extends ThumbnailMaker {
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_KEEP_RATIO = "keepRatio";
    private static final String PARAM_FIT_WITHIN = "fitWithinDimensions";
    private int width;
    private int height;
    private boolean keepRatio;
    private boolean fitWithinDimensions;

    public FixedSizeThumbnailMaker() {
        this.ready.unset(PARAM_SIZE);
        this.ready.unset(PARAM_KEEP_RATIO);
        this.ready.unset(PARAM_FIT_WITHIN);
    }

    public FixedSizeThumbnailMaker(int width, int height) {
        this();
        this.size(width, height);
    }

    public FixedSizeThumbnailMaker(int width, int height, boolean aspectRatio) {
        this();
        this.size(width, height);
        this.keepAspectRatio(aspectRatio);
    }

    public FixedSizeThumbnailMaker(int width, int height, boolean aspectRatio, boolean fit) {
        this();
        this.size(width, height);
        this.keepAspectRatio(aspectRatio);
        this.fitWithinDimensions(fit);
    }

    public FixedSizeThumbnailMaker size(int width, int height) {
        if (this.ready.isSet(PARAM_SIZE)) {
            throw new IllegalStateException("The size has already been set.");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Width must be greater than zero.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Height must be greater than zero.");
        }
        this.width = width;
        this.height = height;
        this.ready.set(PARAM_SIZE);
        return this;
    }

    public FixedSizeThumbnailMaker keepAspectRatio(boolean keep) {
        if (this.ready.isSet(PARAM_KEEP_RATIO)) {
            throw new IllegalStateException("Whether to keep the aspect ratio has already been set.");
        }
        this.keepRatio = keep;
        this.ready.set(PARAM_KEEP_RATIO);
        return this;
    }

    public FixedSizeThumbnailMaker fitWithinDimensions(boolean fit) {
        if (this.ready.isSet(PARAM_FIT_WITHIN)) {
            throw new IllegalStateException("Whether to fit within dimensions has already been set.");
        }
        this.fitWithinDimensions = fit;
        this.ready.set(PARAM_FIT_WITHIN);
        return this;
    }

    public BufferedImage make(BufferedImage img) {
        double targetRatio;
        int sourceHeight;
        int sourceWidth;
        double sourceRatio;
        int targetWidth = this.width;
        int targetHeight = this.height;
        if (this.keepRatio && Double.compare(sourceRatio = (double)(sourceWidth = img.getWidth()) / (double)(sourceHeight = img.getHeight()), targetRatio = (double)targetWidth / (double)targetHeight) != 0) {
            if (this.fitWithinDimensions) {
                if (sourceRatio > targetRatio) {
                    targetWidth = this.width;
                    targetHeight = (int)Math.round((double)targetWidth / sourceRatio);
                } else {
                    targetWidth = (int)Math.round((double)targetHeight * sourceRatio);
                    targetHeight = this.height;
                }
            } else if (sourceRatio > targetRatio) {
                targetWidth = (int)Math.round((double)targetHeight * sourceRatio);
                targetHeight = this.height;
            } else {
                targetWidth = this.width;
                targetHeight = (int)Math.round((double)targetWidth / sourceRatio);
            }
        }
        targetWidth = targetWidth == 0 ? 1 : targetWidth;
        targetHeight = targetHeight == 0 ? 1 : targetHeight;
        return super.makeThumbnail(img, targetWidth, targetHeight);
    }
}

