/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.UUID;
import net.xmind.core.IAccount;
import net.xmind.core.IAuthenticationListener;
import net.xmind.workbench.internal.XMindNetWorkbench;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Bundle;

public class AuthDataCollector
implements IAuthenticationListener {
    private IAccount account = null;
    private JSONObject authStates = null;

    public void setAccount(IAccount account) {
        IAccount oldAccount = this.account;
        if (account == oldAccount) {
            return;
        }
        if (oldAccount != null) {
            oldAccount.removeAuthenticationListener((IAuthenticationListener)this);
        }
        this.account = account;
        if (account != null) {
            account.addAuthenticationListener((IAuthenticationListener)this);
            this.recordAuth(account);
        }
    }

    private void recordAuth(IAccount account) {
        String newUser;
        if (this.authStates == null) {
            this.authStates = AuthDataCollector.readStates(AuthDataCollector.getAuthStatesFile());
        }
        JSONObject oldStates = this.authStates;
        JSONObject newStates = AuthDataCollector.createAuthStates(account);
        String oldUser = oldStates == null ? null : oldStates.optString("user", null);
        String string = newUser = newStates == null ? null : newStates.optString("user", null);
        if (!(newUser == oldUser || newUser != null && newUser.equals(oldUser))) {
            String oldSessionId;
            String string2 = oldSessionId = oldStates == null ? null : oldStates.optString("sessionId", null);
            if (oldSessionId != null) {
                XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("XMindIdAuthorizations/SignOutTime/%s", oldSessionId), System.currentTimeMillis());
            }
            if (newUser != null) {
                String sessionId = UUID.randomUUID().toString();
                newStates.put("sessionId", (Object)sessionId);
                XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("XMindIdAuthorizations/SignInTime/%s", sessionId), System.currentTimeMillis());
                boolean pro = account.hasValidSubscription();
                String accountType = pro ? "pro" : "free";
                XMindNetWorkbench.getDefault().getUsageDataCollector().put(String.format("XMindIdAuthorizations/AccountType/%s", sessionId), accountType);
            }
            this.authStates = newStates;
            AuthDataCollector.writeStates(this.authStates, AuthDataCollector.getAuthStatesFile());
        }
    }

    private static JSONObject createAuthStates(IAccount account) {
        if (!account.isAuthenticated()) {
            return null;
        }
        return new JSONObject().put("user", (Object)((String)account.getProperty("user")));
    }

    private static File getAuthStatesFile() {
        IPath stateLocation;
        Bundle storageBundle = Platform.getBundle((String)"org.xmind.cathy");
        if (storageBundle == null) {
            return null;
        }
        try {
            stateLocation = Platform.getStateLocation((Bundle)storageBundle);
        }
        catch (Exception exception) {
            return null;
        }
        return stateLocation.append("authStates.json").toFile();
    }

    public void onAuthenticated(IAccount account) {
        this.recordAuth(account);
    }

    public void onUnauthenticated(IAccount account) {
        this.recordAuth(account);
    }

    private static JSONObject readStates(File statesFile) {
        JSONObject jSONObject;
        if (statesFile == null || !statesFile.exists()) {
            return null;
        }
        FileInputStream stream = new FileInputStream(statesFile);
        try {
            jSONObject = new JSONObject(new JSONTokener((InputStream)stream));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        ((InputStream)stream).close();
        return jSONObject;
    }

    private static void writeStates(JSONObject object, File statesFile) {
        if (statesFile == null) {
            return;
        }
        if (object == null) {
            statesFile.delete();
            return;
        }
        File dir = statesFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(statesFile);
            try {
                object.write((Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException iOException) {}
    }
}

