/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import java.lang.reflect.Constructor;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.URI;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyTabRendererSWTHandler
extends AbstractCSSPropertySWTHandler {
    public static final ICSSPropertyHandler INSTANCE = new CSSPropertyTabRendererSWTHandler();
    private boolean backwardsCompatURIsLogged = false;

    @Override
    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof CTabFolder)) {
            return;
        }
        if (value.getCssValueType() == 1) {
            if (((CSSPrimitiveValue)value).getPrimitiveType() == 20) {
                String rendURL = ((CSSPrimitiveValue)value).getStringValue();
                if (rendURL.startsWith("platform:/plugin/")) {
                    if (!this.backwardsCompatURIsLogged) {
                        CSSActivator.getDefault().log(1, "platform-style URIs deprecated for referencing types: use bundleclass://<bundlename>/<typename>");
                        this.backwardsCompatURIsLogged = true;
                    }
                    rendURL = rendURL.replace("platform:/plugin/", "bundleclass://");
                }
                URI uri = URI.createURI(rendURL);
                Bundle bundle = CSSActivator.getDefault().getBundleForName(uri.authority());
                if (bundle == null) {
                    CSSActivator.getDefault().log(1, "Failed to get bundle for: " + rendURL);
                } else if (uri.segmentCount() <= 1) {
                    String clazz = uri.segment(0);
                    try {
                        Object rend;
                        Class targetClass = bundle.loadClass(clazz);
                        CTabFolderRenderer renderer = ((CTabFolder)control).getRenderer();
                        if (renderer != null && renderer.getClass() == targetClass) {
                            return;
                        }
                        Constructor constructor = targetClass.getConstructor(CTabFolder.class);
                        if (constructor != null && (rend = constructor.newInstance(control)) != null && rend instanceof CTabFolderRenderer) {
                            ((CTabFolder)control).setRenderer((CTabFolderRenderer)rend);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                        CSSActivator.getDefault().log(1, message);
                    }
                }
            } else {
                ((CTabFolder)control).setRenderer(null);
            }
        }
    }

    @Override
    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

