/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.DefaultDayRenderer;
import net.sf.nachocalendar.components.DefaultHeaderRenderer;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.components.MonthPanel;
import net.sf.nachocalendar.components.YearScroller;
import net.sf.nachocalendar.event.DateSelectionEvent;
import net.sf.nachocalendar.event.DateSelectionListener;
import net.sf.nachocalendar.model.DataModel;
import net.sf.nachocalendar.model.DateSelectionModel;
import net.sf.nachocalendar.model.DefaultDateSelectionModel;

public class CalendarPanel
extends JPanel
implements ChangeListener {
    private boolean antiAliased;
    private KeyListener klistener;
    private MouseListener mlistener;
    private DateSelectionListener listlistener;
    private DateSelectionModel dateSelectionModel;
    private DataModel datamodel;
    private HeaderRenderer headerrenderer;
    private DayRenderer dayrenderer;
    private Calendar navigation;
    private Calendar calendar;
    private Date minDate;
    private Date maxDate;
    private int minimalDaysInFirstWeek;
    private boolean printMoon;
    protected boolean eternalScroll;
    private boolean showToday;
    private int middle;
    private MonthPanel[] months;
    private int orientation;
    private int scrollPosition;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 0;
    public static final int DOWN = 1;
    private JScrollBar scroll;
    private YearScroller ys;
    private JButton today;
    private boolean[] workingdays = new boolean[]{false, true, true, true, true, true, true};
    private Calendar cal;
    private int showingyear;
    private int quantity;
    private Date date;
    private JPanel abajo;
    private boolean showWeekNumber;
    private transient ArrayList changeListenerList;
    private int yearPosition;

    public CalendarPanel() {
        this(3, 1);
    }

    public CalendarPanel(int quantity) {
        this(quantity, 1);
    }

    public CalendarPanel(boolean showWeekNumbers) {
        this(3, 1, showWeekNumbers);
    }

    public CalendarPanel(int quantity, int orientation) {
        this(quantity, orientation, true);
    }

    public CalendarPanel(int quantity, int orientation, boolean showWeekNumber) {
        this(quantity, orientation, showWeekNumber, true);
    }

    public CalendarPanel(int quantity, int orientation, boolean showWeekNumber, boolean eternalScroll) {
        if (quantity < 1) {
            quantity = 1;
        }
        if (quantity > 12) {
            quantity = 12;
        }
        this.quantity = quantity;
        this.showWeekNumber = showWeekNumber;
        this.orientation = orientation;
        this.navigation = new GregorianCalendar();
        this.calendar = new GregorianCalendar();
        this.dateSelectionModel = new DefaultDateSelectionModel();
        this.ys = new YearScroller();
        this.middle = quantity / 2;
        this.eternalScroll = eternalScroll;
        this.initScroll();
        this.today = new JButton(CalendarUtils.getMessage("today"));
        this.today.setVisible(false);
        this.cal = new GregorianCalendar();
        this.setLayout(new BorderLayout());
        this.createListeners();
        this.dateSelectionModel.addDateSelectionListener(this.listlistener);
        this.setQuantity(quantity);
        if (orientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
        this.initDisplayPanel();
        this.setValue(new Date());
        this.setRenderer(new DefaultDayRenderer());
        this.setHeaderRenderer(new DefaultHeaderRenderer());
    }

    private void initScroll() {
        int or = this.orientation == 0 ? 0 : 1;
        this.scroll = new JScrollBar(or);
        this.scroll.setMaximum(17 - this.quantity);
        this.scroll.setBlockIncrement(3);
        this.scroll.setUnitIncrement(1);
        DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(){

            @Override
            public void setValue(int value) {
                super.setValue(value);
                if (CalendarPanel.this.eternalScroll) {
                    if (value < this.getMinimum()) {
                        CalendarPanel.this.goPreviousYear();
                    }
                    if (value > this.getMaximum() - this.getExtent()) {
                        CalendarPanel.this.goNextYear();
                    }
                }
            }
        };
        model.setMaximum(17 - this.quantity);
        model.setMinimum(0);
        model.setExtent(5);
        model.setValue(0);
        this.scroll.setModel(model);
    }

    private void goNextYear() {
        this.ys.setYear(this.ys.getYear() + 1);
        this.setShowingYear(this.ys.getYear());
        this.scroll.setValue(0);
    }

    private void goPreviousYear() {
        this.ys.setYear(this.ys.getYear() - 1);
        this.setShowingYear(this.ys.getYear());
        this.scroll.setValue(this.scroll.getMaximum() - this.scroll.getModel().getExtent());
    }

    private void initDisplayPanel() {
        int displayRange = this.cal.get(2);
        this.setShowingYear(this.cal.get(1));
        if (0 < displayRange && displayRange - this.middle < 10) {
            this.scroll.setValue(displayRange - this.middle);
        } else if (displayRange < this.quantity) {
            this.scroll.setValue(displayRange);
        } else {
            this.scroll.setValue(displayRange - this.quantity - this.middle);
        }
    }

    private void createListeners() {
        this.scroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                CalendarPanel.this.setShowingMonth(e.getValue());
            }
        });
        this.ys.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CalendarPanel.this.setShowingYear(CalendarPanel.this.ys.getYear());
            }
        });
        this.today.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.cal.setTime(new Date());
                CalendarPanel.this.initDisplayPanel();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!CalendarPanel.this.isEnabled()) {
                    return;
                }
                int q = e.getWheelRotation();
                int value = CalendarPanel.this.scroll.getValue();
                if ((value += q) < 0) {
                    value = 0;
                    if (CalendarPanel.this.eternalScroll) {
                        CalendarPanel.this.goPreviousYear();
                        return;
                    }
                }
                if (value > 11) {
                    value = 11;
                    if (CalendarPanel.this.eternalScroll) {
                        CalendarPanel.this.goNextYear();
                        return;
                    }
                }
                CalendarPanel.this.scroll.setValue(value);
            }
        });
        this.klistener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean changed = false;
                int keycode = e.getKeyCode();
                CalendarPanel.this.navigation.setTime(CalendarPanel.this.calendar.getTime());
                if (keycode == 37 || keycode == 226) {
                    CalendarPanel.this.navigation.add(6, -1);
                    changed = true;
                }
                if (keycode == 39 || keycode == 227) {
                    CalendarPanel.this.navigation.add(6, 1);
                    changed = true;
                }
                if (keycode == 38 || keycode == 224) {
                    CalendarPanel.this.navigation.add(6, -7);
                    changed = true;
                }
                if (keycode == 40 || keycode == 225) {
                    CalendarPanel.this.navigation.add(6, 7);
                    changed = true;
                }
                if (keycode == 33) {
                    CalendarPanel.this.navigation.add(2, -1);
                    CalendarPanel.this.scroll.setValue(CalendarPanel.this.navigation.get(2));
                    changed = true;
                }
                if (keycode == 34) {
                    CalendarPanel.this.navigation.add(2, 1);
                    CalendarPanel.this.scroll.setValue(CalendarPanel.this.navigation.get(2));
                    changed = true;
                }
                if (changed) {
                    if (!CalendarPanel.this.isShowing(CalendarPanel.this.navigation.getTime())) {
                        CalendarPanel.this.showMonth(CalendarPanel.this.navigation.getTime());
                    }
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        CalendarPanel.this.dateSelectionModel.clearSelection();
                        if (e.isShiftDown()) {
                            CalendarPanel.this.dateSelectionModel.addSelectionInterval(CalendarPanel.this.dateSelectionModel.getLeadSelectionDate(), CalendarPanel.this.navigation.getTime());
                        } else {
                            CalendarPanel.this.dateSelectionModel.addSelectionInterval(CalendarPanel.this.navigation.getTime(), CalendarPanel.this.navigation.getTime());
                        }
                    } else if (e.isShiftDown()) {
                        CalendarPanel.this.dateSelectionModel.addSelectionInterval(CalendarPanel.this.dateSelectionModel.getLeadSelectionDate(), CalendarPanel.this.navigation.getTime());
                    } else if (CalendarPanel.this.dateSelectionModel.isSelectedDate(CalendarPanel.this.navigation.getTime())) {
                        CalendarPanel.this.dateSelectionModel.removeSelectionInterval(CalendarPanel.this.navigation.getTime(), CalendarPanel.this.navigation.getTime());
                    } else {
                        CalendarPanel.this.dateSelectionModel.addSelectionInterval(CalendarPanel.this.navigation.getTime(), CalendarPanel.this.navigation.getTime());
                    }
                    CalendarPanel.this.dateSelectionModel.setLeadSelectionDate(CalendarPanel.this.navigation.getTime());
                    CalendarPanel.this.calendar.setTime(CalendarPanel.this.navigation.getTime());
                    CalendarPanel.this.refreshSelection();
                    CalendarPanel.this.repaint();
                }
                CalendarPanel.this.fireKeyListenerKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CalendarPanel.this.fireKeyListenerKeyReleased(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                CalendarPanel.this.fireKeyListenerKeyTyped(e);
            }
        };
        this.mlistener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DayPanel dp = (DayPanel)e.getSource();
                if (!dp.isEnabled() || !dp.isComponentEnabled()) {
                    return;
                }
                CalendarPanel.this.dateSelectionModel.setValueIsAdjusting(true);
                if (!e.isControlDown()) {
                    CalendarPanel.this.dateSelectionModel.clearSelection();
                    if (e.isShiftDown()) {
                        CalendarPanel.this.dateSelectionModel.addSelectionInterval(CalendarPanel.this.dateSelectionModel.getLeadSelectionDate(), dp.getDate());
                    } else {
                        CalendarPanel.this.dateSelectionModel.addSelectionInterval(dp.getDate(), dp.getDate());
                    }
                } else if (e.isShiftDown()) {
                    CalendarPanel.this.dateSelectionModel.addSelectionInterval(CalendarPanel.this.dateSelectionModel.getLeadSelectionDate(), dp.getDate());
                } else if (CalendarPanel.this.dateSelectionModel.isSelectedDate(dp.getDate())) {
                    CalendarPanel.this.dateSelectionModel.removeSelectionInterval(dp.getDate(), dp.getDate());
                } else {
                    CalendarPanel.this.dateSelectionModel.addSelectionInterval(dp.getDate(), dp.getDate());
                }
                CalendarPanel.this.dateSelectionModel.setLeadSelectionDate(dp.getDate());
                CalendarPanel.this.repaint();
                dp.requestFocus();
                CalendarPanel.this.calendar.setTime(dp.getDate());
                CalendarPanel.this.dateSelectionModel.setValueIsAdjusting(false);
                CalendarPanel.this.refreshSelection();
                CalendarPanel.this.repaint();
            }
        };
        this.listlistener = new DateSelectionListener(){

            @Override
            public void valueChanged(DateSelectionEvent e) {
                for (int i = 0; i < CalendarPanel.this.months.length; ++i) {
                    DayPanel[] daypanels = CalendarPanel.this.months[i].getDaypanels();
                    for (int j = 0; j < daypanels.length; ++j) {
                        if (CalendarPanel.this.dateSelectionModel.isSelectedDate(daypanels[j].getDate())) {
                            daypanels[j].setSelected(true);
                            continue;
                        }
                        daypanels[j].setSelected(false);
                    }
                }
                CalendarPanel.this.repaint();
                CalendarPanel.this.fireChangeListenerStateChanged(new ChangeEvent(CalendarPanel.this));
            }
        };
    }

    public void setOrientation(int orientation) {
        if (orientation == this.orientation) {
            return;
        }
        int old = this.orientation;
        this.orientation = orientation;
        this.removeAll();
        if (orientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
        this.firePropertyChange("orientation", old, orientation);
    }

    private void layoutVertical() {
        this.scroll.setOrientation(1);
        JPanel centro = new JPanel(new GridLayout(this.months.length, 1));
        for (int i = 0; i < this.months.length; ++i) {
            centro.add(this.months[i]);
        }
        this.add((Component)centro, "Center");
        this.layoutScrollAndYear();
    }

    private void layoutHorizontal() {
        this.scroll.setOrientation(0);
        JPanel centro = new JPanel(new GridLayout(1, this.months.length));
        for (int i = 0; i < this.months.length; ++i) {
            centro.add(this.months[i]);
        }
        this.add((Component)centro, "Center");
        this.layoutScrollAndYear();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged(ChangeEvent event) {
        ArrayList list;
        CalendarPanel calendarPanel = this;
        synchronized (calendarPanel) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeListenerStateChanged(e);
    }

    private void setShowingMonth(int month) {
        GregorianCalendar cal = new GregorianCalendar(this.showingyear, month, 1);
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setMonth(cal.getTime());
            ((Calendar)cal).add(2, 1);
        }
        this.minDate = this.months[0].getMinDate();
        this.maxDate = this.months[this.months.length - 1].getMaxDate();
        this.refreshSelection();
    }

    private void setShowingYear(int year) {
        this.showingyear = year;
        for (int i = 0; i < this.months.length; ++i) {
            this.cal.setTime(this.months[i].getMonth());
            this.cal.set(1, year);
            this.months[i].setMonth(this.cal.getTime());
        }
        this.refreshSelection();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        this.date = date;
        this.cal.setTime(date);
        if (!this.isShowing(date)) {
            this.showMonth(date);
        }
        this.dateSelectionModel.setSelectedDate(date);
        this.refreshSelection();
        this.repaint();
    }

    public boolean[] getWorkingdays() {
        return this.workingdays;
    }

    public void setWorkingdays(boolean[] workingdays) {
        boolean[] old = this.workingdays;
        this.workingdays = workingdays;
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setWorkingdays(workingdays);
        }
        this.firePropertyChange("workingDays", old, workingdays);
    }

    public DayRenderer getRenderer() {
        return this.months[0].getRenderer();
    }

    public void setRenderer(DayRenderer renderer) {
        this.dayrenderer = renderer;
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setRenderer(renderer);
        }
    }

    public DataModel getModel() {
        return this.months[0].getModel();
    }

    public void setModel(DataModel model) {
        this.datamodel = model;
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setModel(model);
        }
    }

    public int getFirstDayOfWeek() {
        return this.months[0].getFirstDayOfWeek();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == 1 || firstDayOfWeek == 2) {
            int old = this.months[0].getFirstDayOfWeek();
            if (firstDayOfWeek == this.months[0].getFirstDayOfWeek()) {
                return;
            }
            for (int i = 0; i < this.months.length; ++i) {
                this.months[i].setFirstDayOfWeek(firstDayOfWeek);
            }
            this.refreshSelection();
            this.repaint();
            this.firePropertyChange("firstDayOfWeek", old, firstDayOfWeek);
        }
    }

    public void refresh() {
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].refresh();
        }
    }

    public HeaderRenderer getHeaderRenderer() {
        return this.months[0].getHeaderRenderer();
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        this.headerrenderer = headerRenderer;
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setHeaderRenderer(headerRenderer);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(int scrollPosition) {
        if (scrollPosition == this.scrollPosition) {
            return;
        }
        int old = this.scrollPosition;
        this.scrollPosition = scrollPosition;
        if (this.orientation == 0) {
            this.remove(this.abajo);
        } else {
            this.remove(this.ys);
            this.remove(this.scroll);
        }
        this.layoutScrollAndYear();
        this.firePropertyChange("scrollPosition", old, scrollPosition);
    }

    public int getYearPosition() {
        return this.yearPosition;
    }

    public void setYearPosition(int yearPosition) {
        if (yearPosition == this.yearPosition) {
            return;
        }
        int old = this.yearPosition;
        this.yearPosition = yearPosition;
        if (this.orientation == 0) {
            this.remove(this.abajo);
        } else {
            this.remove(this.ys);
            this.remove(this.scroll);
        }
        this.layoutScrollAndYear();
        this.firePropertyChange("yearPosition", old, yearPosition);
    }

    private void layoutScrollAndYear() {
        if (this.orientation == 1) {
            if (this.yearPosition == 0) {
                this.add((Component)this.ys, "North");
                this.add((Component)this.today, "South");
            } else {
                this.add((Component)this.ys, "South");
                this.add((Component)this.today, "North");
            }
            if (this.scrollPosition == 0) {
                this.add((Component)this.scroll, "West");
            } else {
                this.add((Component)this.scroll, "East");
            }
        } else {
            this.abajo = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weighty = 1.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.fill = 1;
            if (this.yearPosition == 0) {
                gbc.weightx = 0.0;
                this.abajo.add((Component)this.ys, gbc);
                gbc.weightx = 1.0;
                this.abajo.add((Component)this.scroll, gbc);
                gbc.weightx = 0.0;
                this.abajo.add((Component)this.today, gbc);
            } else {
                gbc.weightx = 0.0;
                this.abajo.add((Component)this.today, gbc);
                gbc.weightx = 1.0;
                this.abajo.add((Component)this.scroll, gbc);
                gbc.weightx = 0.0;
                this.abajo.add((Component)this.ys, gbc);
            }
            if (this.scrollPosition == 0) {
                this.add((Component)this.abajo, "North");
            } else {
                this.add((Component)this.abajo, "South");
            }
        }
    }

    public int getQuantity() {
        return this.months.length;
    }

    public void setQuantity(int quantity) {
        if (quantity < 1) {
            quantity = 1;
        }
        if (quantity > 12) {
            quantity = 12;
        }
        if (this.months != null && this.months.length == quantity) {
            return;
        }
        int old = this.quantity;
        this.months = new MonthPanel[quantity];
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i] = new MonthPanel(this.showWeekNumber);
            this.months[i].showTitle(true);
            this.months[i].setModel(this.datamodel);
            this.months[i].setRenderer(this.dayrenderer);
            this.months[i].setHeaderRenderer(this.headerrenderer);
            this.months[i].setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            this.months[i].setDay(new Date());
            DayPanel[] daypanels = this.months[i].getDaypanels();
            for (int j = 0; j < daypanels.length; ++j) {
                daypanels[j].addKeyListener(this.klistener);
                daypanels[j].addMouseListener(this.mlistener);
            }
        }
        int oldor = this.orientation;
        this.orientation = -1;
        this.setOrientation(oldor);
        this.quantity = quantity;
        this.scroll.setMaximum(17 - quantity);
        if (old != 0) {
            this.firePropertyChange("quantity", old, quantity);
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(KeyListener.class, listener);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener listener) {
        this.listenerList.remove(KeyListener.class, listener);
    }

    private void fireKeyListenerKeyTyped(KeyEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeyListener.class) continue;
            ((KeyListener)listeners[i + 1]).keyTyped(event);
        }
    }

    private void fireKeyListenerKeyPressed(KeyEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeyListener.class) continue;
            ((KeyListener)listeners[i + 1]).keyPressed(event);
        }
    }

    private void fireKeyListenerKeyReleased(KeyEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeyListener.class) continue;
            ((KeyListener)listeners[i + 1]).keyReleased(event);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setEnabled(enabled);
        }
        this.scroll.setEnabled(enabled);
        this.ys.setEnabled(enabled);
        this.repaint();
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.scroll.isEnabled();
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        for (int i = 0; i < this.months.length; ++i) {
            this.months[i].setAntiAliased(antiAliased);
        }
        this.firePropertyChange("antiAliased", old, antiAliased);
    }

    public int getSelectionMode() {
        return this.dateSelectionModel.getSelectionMode();
    }

    public void setSelectionMode(int selectionMode) {
        int old = this.dateSelectionModel.getSelectionMode();
        this.dateSelectionModel.setSelectionMode(selectionMode);
        this.refreshSelection();
        this.firePropertyChange("selectionMode", old, selectionMode);
    }

    private void refreshSelection() {
        for (int i = 0; i < this.months.length; ++i) {
            DayPanel[] daypanels = this.months[i].getDaypanels();
            for (int j = 0; j < daypanels.length; ++j) {
                if (!daypanels[j].isEnabled()) {
                    daypanels[j].setSelected(false);
                    continue;
                }
                daypanels[j].setSelected(this.dateSelectionModel.isSelectedDate(daypanels[j].getDate()));
            }
        }
    }

    private boolean isShowing(Date date) {
        if (date.before(this.minDate)) {
            return false;
        }
        return !date.after(this.maxDate);
    }

    private void showMonth(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        if (this.ys.getYear() != cal.get(1)) {
            this.ys.setYear(cal.get(1));
            this.setShowingYear(this.ys.getYear());
        }
        if (this.isShowing(d)) {
            return;
        }
        int month = cal.get(2);
        int middle = this.quantity / 2;
        int show = 0;
        show = month < this.scroll.getValue() ? month : month - this.quantity + 1;
        if (show < 0) {
            show = 0;
        }
        if (show > 11 - this.quantity + middle) {
            show = 11 - this.quantity + middle;
        }
        this.scroll.setValue(show);
    }

    public Object getValue() {
        return this.dateSelectionModel.getSelectedDate();
    }

    public Object[] getValues() {
        return this.dateSelectionModel.getSelectedDates();
    }

    public void setValue(Object date) {
        try {
            this.setDate(CalendarUtils.convertToDate(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setValues(Object[] dates) {
        this.dateSelectionModel.setSelectedDates(dates);
        this.refreshSelection();
        this.repaint();
        this.showMonth((Date)this.dateSelectionModel.getSelectedDates()[0]);
    }

    public DateSelectionModel getDateSelectionModel() {
        return this.dateSelectionModel;
    }

    public void setDateSelectionModel(DateSelectionModel dateSelectionModel) {
        if (dateSelectionModel != null) {
            this.dateSelectionModel.removeDateSelectionListener(this.listlistener);
            this.dateSelectionModel = dateSelectionModel;
            dateSelectionModel.addDateSelectionListener(this.listlistener);
        }
    }

    public void setMinimalDaysInFirstWeek(int number) {
        if (this.months[0].getMinimalDaysInFirstWeek() != number) {
            for (int i = 0; i < this.months.length; ++i) {
                this.months[i].setMinimalDaysInFirstWeek(number);
            }
            this.refreshSelection();
            this.repaint();
            this.firePropertyChange("minimalDaysInFirstWeek", this.minimalDaysInFirstWeek, number);
            this.minimalDaysInFirstWeek = number;
        }
    }

    public int getMinimalDaysInFirstWeek() {
        return this.months[0].getMinimalDaysInFirstWeek();
    }

    public boolean isPrintMoon() {
        return this.printMoon;
    }

    public void setPrintMoon(boolean printMoon) {
        if (this.printMoon != printMoon) {
            this.printMoon = printMoon;
            for (int i = 0; i < this.months.length; ++i) {
                this.months[i].setPrintMoon(printMoon);
            }
            this.refreshSelection();
            this.repaint();
            this.firePropertyChange("printMoon", printMoon, !printMoon);
        }
    }

    public void setTodayCaption(String caption) {
        if (caption == null) {
            this.today.setText(CalendarUtils.getMessage("today"));
        } else {
            this.today.setText(caption);
        }
    }

    public boolean isEternalScroll() {
        return this.eternalScroll;
    }

    public void setEternalScroll(boolean eternalScroll) {
        this.eternalScroll = eternalScroll;
    }

    public boolean isShowToday() {
        return this.showToday;
    }

    public void setShowToday(boolean showToday) {
        this.today.setVisible(showToday);
        this.repaint();
        this.showToday = showToday;
    }
}

