/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.gui.FigureAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGPropertiesPanel
extends JPanel {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
    private DrawingEditor editor;
    private JAttributeSlider opacitySlider;
    private FigureAttributeEditorHandler opacityFieldHandler;
    private FigureAttributeEditorHandler opacitySliderHandler;
    private FigureAttributeEditorHandler linkFieldHandler;
    private JAttributeTextField linkField;
    private JLabel linkLabel;
    private JAttributeTextField opacityField;
    private JLabel opacityLabel;
    private JPopupButton opacityPopupButton;

    public ODGPropertiesPanel() {
        this.initComponents();
        this.opacitySlider = new JAttributeSlider(1, 0, 100, 100);
        this.opacityPopupButton.add(this.opacitySlider);
        this.opacityPopupButton.putClientProperty("JButton.buttonType", "toolbar");
        this.add(this.opacityPopupButton);
        this.opacityField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
        this.opacityFieldHandler = new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, this.opacityField, this.editor);
        this.opacitySliderHandler = new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, this.opacitySlider, this.editor);
        this.linkFieldHandler = new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK, this.linkField, this.editor);
        Font font = this.getFont().deriveFont(11.0f);
        for (Component c : this.getComponents()) {
            c.setFont(font);
        }
        this.opacitySlider.setFont(font);
    }

    public void setEditor(DrawingEditor editor) {
        this.editor = editor;
        this.linkFieldHandler.setDrawingEditor(editor);
        this.opacitySliderHandler.setDrawingEditor(editor);
        this.opacityFieldHandler.setDrawingEditor(editor);
    }

    public void setView(DrawingView view) {
        this.opacityFieldHandler.setView(view);
        this.opacitySliderHandler.setView(view);
        this.linkFieldHandler.setView(view);
    }

    private void initComponents() {
        this.linkLabel = new JLabel();
        this.linkField = new JAttributeTextField();
        this.opacityLabel = new JLabel();
        this.opacityField = new JAttributeTextField();
        this.opacityPopupButton = new JPopupButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this.linkLabel.setLabelFor(this.linkField);
        this.linkLabel.setText(this.labels.getString("link"));
        this.add((Component)this.linkLabel, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.linkField, gridBagConstraints);
        this.opacityLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/attributeOpacity.png")));
        this.opacityLabel.setToolTipText(this.labels.getString("opacity"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.opacityLabel, gridBagConstraints);
        this.opacityField.setColumns(3);
        this.add((Component)this.opacityField, new GridBagConstraints());
        this.opacityPopupButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/popupIcon.png")));
        this.add((Component)this.opacityPopupButton, new GridBagConstraints());
    }
}

