/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.org.apache.commons.codec.binary;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Base64 {
    protected static final byte PAD_DEFAULT = 61;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    static boolean isBase64(byte octet) {
        return octet >= 0 && octet < DECODE_TABLE.length && DECODE_TABLE[octet] != -1;
    }

    private static boolean isPadding(byte octet) {
        return octet == 61;
    }

    public static boolean isBase64(String base64) {
        return Base64.isBase64(Base64.getBytesUtf8(base64));
    }

    private static boolean isBase64(byte[] arrayOctet) {
        int length = arrayOctet.length;
        if (length % 4 != 0) {
            return false;
        }
        int end = Math.max(0, length - 2);
        for (int i = 0; i < end; ++i) {
            if (Base64.isBase64(arrayOctet[i])) continue;
            return false;
        }
        boolean padding = false;
        for (int i = end; i < arrayOctet.length; ++i) {
            byte octet = arrayOctet[i];
            if (padding) {
                if (Base64.isPadding(octet)) continue;
                return false;
            }
            if (Base64.isPadding(octet)) {
                padding = true;
                continue;
            }
            if (Base64.isBase64(octet)) continue;
            return false;
        }
        return true;
    }

    private static byte[] getBytesUtf8(String string) {
        return Base64.getBytes(string, StandardCharsets.UTF_8);
    }

    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }
}

