/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextAreaCreationTool;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.ToggleGridAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.util.ResourceBundleUtil;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.DispType;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryMonitor;
import org.yccheok.jstock.engine.StockHistorySerializer;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.AutoCompleteJComboBox;
import org.yccheok.jstock.gui.DeleteAction;
import org.yccheok.jstock.gui.IndicatorDefaultDrawing;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MutableStock;
import org.yccheok.jstock.gui.PropertiesAction;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.ObjectInspectorJPanel;
import org.yccheok.jstock.gui.analysis.OperatorFigureCreationTool;
import org.yccheok.jstock.gui.analysis.WizardDownloadIndicatorDescriptor;
import org.yccheok.jstock.gui.analysis.WizardSelectIndicatorDescriptor;
import org.yccheok.jstock.gui.analysis.WizardSelectInstallIndicatorMethodDescriptor;
import org.yccheok.jstock.gui.analysis.WizardSelectInstallIndicatorMethodJPanel;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class IndicatorPanel
extends JPanel {
    private DrawingEditor editor;
    private StockHistoryMonitor stockHistoryMonitor = null;
    private static final int HISTORY_MONITOR_MAX_THREAD = 1;
    private IndicatorProjectManager alertIndicatorProjectManager;
    private IndicatorProjectManager moduleIndicatorProjectManager;
    private static final Log log = LogFactory.getLog(IndicatorPanel.class);
    private StockTask stockTask;
    private volatile Thread simulationThread;
    private static final int NUM_OF_RETRY = 3;
    private ListSelectionEx listSelectionEx = null;
    private JToolBar creationToolbar;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JComboBox jComboBox1;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JPanel objectInspectorJPanel;
    private JScrollPane scrollPane;
    private ButtonGroup toolButtonGroup;
    private DefaultDrawingView view;

    public IndicatorPanel() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"org.jhotdraw.draw.Labels");
        this.initComponents();
        this.jPanel7.add((Component)Utils.getBusyJXLayer((AutoCompleteJComboBox)this.jComboBox1));
        this.editor = new DefaultDrawingEditor();
        this.editor.add((DrawingView)this.view);
        this.addCreationButtonsTo(this.creationToolbar, this.editor);
        JPopupButton pb = new JPopupButton();
        pb.setItemFont(UIManager.getFont("MenuItem.font"));
        labels.configureToolBarButton((AbstractButton)pb, "actions");
        pb.add((Action)new GroupAction(this.editor));
        pb.add((Action)new UngroupAction(this.editor));
        pb.addSeparator();
        pb.add((Action)new BringToFrontAction(this.editor));
        pb.add((Action)new SendToBackAction(this.editor));
        pb.addSeparator();
        pb.add((Action)new SelectAllAction());
        pb.add((Action)new SelectSameAction(this.editor));
        pb.addSeparator();
        pb.add((Action)new ToggleGridAction(this.editor));
        JMenu m = new JMenu(labels.getString("zoom"));
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 0.1, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 0.25, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 0.5, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 0.75, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 1.0, null));
        m.add(rbmi);
        rbmi.setSelected(true);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 1.25, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 1.5, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 2.0, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 3.0, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem((Action)new ZoomAction(this.editor, 4.0, null));
        m.add(rbmi);
        group.add(rbmi);
        pb.add(m);
        pb.setFocusable(false);
        this.creationToolbar.addSeparator();
        this.creationToolbar.add((Component)pb);
        this.view.setDrawing(this.createDrawing());
        this.stockTask = null;
        this.initIndicatorProjectManager();
        this.initModuleProjectManager();
        this.initListCellRenderer();
        this.createToolTipTextForJTabbedPane();
    }

    private Drawing createDrawing() {
        IndicatorDefaultDrawing drawing = new IndicatorDefaultDrawing();
        return drawing;
    }

    public void setDrawing(Drawing d) {
        this.view.setDrawing(d);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.jPanel10 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jComboBox1 = new AutoCompleteJComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.jPanel1 = new JPanel();
        this.creationToolbar = new JToolBar();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton5 = new JButton();
        this.jButton2 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel11 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jButton4 = new JButton();
        this.jButton6 = new JButton();
        this.jPanel7 = new JPanel();
        this.objectInspectorJPanel = new ObjectInspectorJPanel(new MutableStock(org.yccheok.jstock.engine.Utils.getEmptyStock(Code.newInstance(""), Symbol.newInstance(""))));
        this.jPanel10.setLayout(new BorderLayout());
        this.jList2.setSelectionMode(0);
        this.jList2.setModel(new DefaultListModel());
        this.jList2.addMouseListener(new JListPopupListener());
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IndicatorPanel.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.jPanel10.add((Component)this.jScrollPane2, "Center");
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(150, 24));
        ((AutoCompleteJComboBox)this.jComboBox1).attachStockInfoObserver(this.getStockInfoObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachDispObserver(this.getDispObserver());
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setResizeWeight(0.9);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(bundle.getString("IndicatorPanel_StockIndicator")));
        this.jPanel4.setLayout(new BorderLayout(5, 5));
        this.scrollPane.setViewportView((Component)this.view);
        this.jPanel4.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.creationToolbar.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.creationToolbar, gridBagConstraints);
        this.jPanel4.add((Component)this.jPanel1, "South");
        this.jSplitPane1.setLeftComponent(this.jPanel4);
        this.jSplitPane2.setDividerLocation(305);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setMinimumSize(new Dimension(300, 261));
        this.jSplitPane2.setPreferredSize(new Dimension(150, 368));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("IndicatorPanel_Database")));
        this.jPanel2.setLayout(new BorderLayout(5, 5));
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        this.jButton1.setText(bundle.getString("New..."));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filesave.png")));
        this.jButton5.setText(bundle.getString("Save"));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton5);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/download.png")));
        this.jButton2.setText(bundle.getString("Install..."));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel11.setLayout(new BorderLayout());
        this.jList1.setSelectionMode(0);
        this.jList1.setModel(new DefaultListModel());
        this.jList1.addMouseListener(new JListPopupListener());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IndicatorPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jPanel11.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab(bundle.getString("IndicatorPanel_AlertIndicator"), new ImageIcon(this.getClass().getResource("/images/16x16/bell.png")), this.jPanel11);
        this.jPanel2.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane2.setTopComponent(this.jPanel2);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(bundle.getString("IndicatorPanel_StockSampleData")));
        this.jPanel5.setLayout(new BorderLayout(5, 5));
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/player_play.png")));
        this.jButton4.setText(bundle.getString("IndicatorPanel_Simulate"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton4);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/stop.png")));
        this.jButton6.setText(bundle.getString("IndicatorPanel_Stop"));
        this.jButton6.setEnabled(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton6);
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel5.add((Component)this.jPanel7, "North");
        this.jPanel5.add((Component)this.objectInspectorJPanel, "Center");
        this.jSplitPane2.setBottomComponent(this.jPanel5);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.jButton4.setEnabled(true);
        this.jButton6.setEnabled(false);
        this.stop();
        JStock m = JStock.instance();
        m.setStatusBar(false, GUIBundle.getString("IndicatorPanel_SimulationStopped"));
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.Save(true);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        String projectName = (String)this.jList1.getSelectedValue();
        if (projectName == null) {
            this.listSelectionEx = null;
            return;
        }
        IndicatorDefaultDrawing indicatorDefaultDrawing = this.alertIndicatorProjectManager.getIndicatorDefaultDrawing(projectName);
        boolean userCancel = false;
        if (indicatorDefaultDrawing != null) {
            if (this.promptToSaveSignificantEdits(this.listSelectionEx)) {
                this.setDrawing((Drawing)indicatorDefaultDrawing);
            } else {
                userCancel = true;
            }
        } else if (this.promptToSaveSignificantEdits(this.listSelectionEx)) {
            String output = MessageFormat.format(MessagesBundle.getString("question_message_corrupted_file_remove_template"), projectName);
            if (JOptionPane.showConfirmDialog(this, output, MessagesBundle.getString("question_title_corrupted_file_remove"), 0) == 0) {
                this.Delete(false);
            } else {
                this.setDrawing(this.createDrawing());
            }
        } else {
            userCancel = true;
        }
        if (!userCancel) {
            this.jList2.clearSelection();
            this.listSelectionEx = ListSelectionEx.newInstance(this.jList1, projectName);
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        JStock m = JStock.instance();
        IndicatorDefaultDrawing indicatorDefaultDrawing = (IndicatorDefaultDrawing)this.view.getDrawing();
        OperatorIndicator operatorIndicator = indicatorDefaultDrawing.getOperatorIndicator();
        Stock stock = null;
        if (operatorIndicator.isStockNeeded() || operatorIndicator.isStockHistoryServerNeeded()) {
            Object o = ((ObjectInspectorJPanel)((Object)this.objectInspectorJPanel)).getBean();
            MutableStock mutableStock = (MutableStock)o;
            stock = mutableStock.getStock();
            if (stock.code.toString().equals("")) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_select_a_stock"), MessagesBundle.getString("warning_title_you_need_to_select_a_stock"), 2);
                this.jComboBox1.requestFocus();
                return;
            }
        }
        this.jButton4.setEnabled(false);
        this.jButton6.setEnabled(true);
        Thread thread = this.simulationThread;
        this.simulationThread = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        final Stock tmpStock = stock;
        this.simulationThread = new Thread(new Runnable(){

            @Override
            public void run() {
                IndicatorPanel.this.simulate(tmpStock);
            }
        });
        this.simulationThread.start();
    }

    private void New() {
        if (!this.promptToSaveSignificantEdits()) {
            return;
        }
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.alertIndicatorNew();
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.moduleIndicatorNew();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promptToSaveSignificantEdits(ListSelectionEx _listSelectionEx) {
        int result;
        boolean hasSignificantEdits = ((IndicatorDefaultDrawing)this.view.getDrawing()).hasSignificantEdits();
        if (!hasSignificantEdits) {
            return true;
        }
        String output = MessagesBundle.getString("question_message_current_drawing_is_modified_save_it");
        if (_listSelectionEx != null) {
            output = MessageFormat.format(MessagesBundle.getString("question_message_current_drawing_is_modified_save_it_template"), _listSelectionEx.projectName);
        }
        if ((result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_current_drawing_is_modified_save_it"), 1, 3)) == 0) {
            if (_listSelectionEx != null) {
                if (this.jList1 == _listSelectionEx.list) {
                    this._alertIndicatorSave(_listSelectionEx.projectName, false);
                } else if (this.jList2 == _listSelectionEx.list) {
                    this._moduleIndicatorSave(_listSelectionEx.projectName, false);
                }
            } else if (this.jTabbedPane1.getSelectedIndex() == 0) {
                this._alertIndicatorSave(null, false);
            } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
                this._moduleIndicatorSave(null, false);
            }
        }
        if (result == 2) {
            ListSelectionListener[] listSelectionListeners1 = this.jList1.getListSelectionListeners();
            ListSelectionListener[] listSelectionListeners2 = this.jList2.getListSelectionListeners();
            try {
                for (ListSelectionListener listSelectionListener : listSelectionListeners1) {
                    this.jList1.removeListSelectionListener(listSelectionListener);
                }
                for (ListSelectionListener listSelectionListener : listSelectionListeners2) {
                    this.jList2.removeListSelectionListener(listSelectionListener);
                }
                if (_listSelectionEx != null) {
                    if (_listSelectionEx.list == this.jList1) {
                        this.jList1.setSelectedValue(_listSelectionEx.projectName, true);
                        this.jList2.clearSelection();
                    } else {
                        assert (_listSelectionEx.list == this.jList2);
                        this.jList2.setSelectedValue(_listSelectionEx.projectName, true);
                        this.jList1.clearSelection();
                    }
                } else {
                    this.jList1.clearSelection();
                    this.jList2.clearSelection();
                }
            }
            finally {
                for (ListSelectionListener listSelectionListener : listSelectionListeners1) {
                    this.jList1.addListSelectionListener(listSelectionListener);
                }
                for (ListSelectionListener listSelectionListener : listSelectionListeners2) {
                    this.jList2.addListSelectionListener(listSelectionListener);
                }
            }
        }
        return result != 2;
    }

    public boolean promptToSaveSignificantEdits() {
        boolean hasSignificantEdits = ((IndicatorDefaultDrawing)this.view.getDrawing()).hasSignificantEdits();
        if (!hasSignificantEdits) {
            return true;
        }
        String output = MessagesBundle.getString("question_message_current_drawing_is_modified_save_it");
        if (this.jList1.getSelectedValue() != null) {
            output = MessageFormat.format(MessagesBundle.getString("question_message_current_drawing_is_modified_save_it_template"), this.jList1.getSelectedValue());
        } else if (this.jList2.getSelectedValue() != null) {
            output = MessageFormat.format(MessagesBundle.getString("question_message_current_drawing_is_modified_save_it_template"), this.jList2.getSelectedValue());
        }
        int result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_current_drawing_is_modified_save_it"), 1, 3);
        if (result == 0) {
            if (this.jList1.getSelectedValue() != null) {
                this.alertIndicatorSave(false);
            } else if (this.jList2.getSelectedValue() != null) {
                this.moduleIndicatorSave(false);
            } else {
                this.Save(false);
            }
        }
        return result != 2;
    }

    private void alertIndicatorNew() {
        String projectName = null;
        while ((projectName = JOptionPane.showInputDialog(this, (Object)MessagesBundle.getString("info_message_enter_new_alert_indicator_name"))) != null) {
            if ((projectName = projectName.trim()).length() == 0) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_alert_indicator_name"), MessagesBundle.getString("warning_title_you_need_to_specific_alert_indicator_name"), 2);
                continue;
            }
            if (this.alertIndicatorProjectManager.contains(projectName)) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_an_alert_indicator_with_same_name"), MessagesBundle.getString("warning_title_already_an_alert_indicator_with_same_name"), 2);
                continue;
            }
            IndicatorDefaultDrawing newDrawing = (IndicatorDefaultDrawing)this.createDrawing();
            if (this.alertIndicatorProjectManager.addProject(newDrawing, projectName)) {
                this.syncJListWithIndicatorProjectManager(this.jList1, this.alertIndicatorProjectManager);
                this.jList1.setSelectedValue(projectName, true);
                return;
            }
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_alert_indicator_name"), MessagesBundle.getString("warning_title_invalid_alert_indicator_name"), 2);
        }
        return;
    }

    private void moduleIndicatorNew() {
        String projectName = null;
        while ((projectName = JOptionPane.showInputDialog(this, (Object)MessagesBundle.getString("info_message_enter_new_module_indicator_name"))) != null) {
            if ((projectName = projectName.trim()).length() == 0) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_module_indicator_name"), MessagesBundle.getString("warning_title_you_need_to_specific_module_indicator_name"), 2);
                continue;
            }
            if (this.moduleIndicatorProjectManager.contains(projectName)) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_module_indicator_with_same_name"), MessagesBundle.getString("warning_title_already_a_module_indicator_with_same_name"), 2);
                continue;
            }
            IndicatorDefaultDrawing newDrawing = (IndicatorDefaultDrawing)this.createDrawing();
            if (this.moduleIndicatorProjectManager.addProject(newDrawing, projectName)) {
                this.syncJListWithIndicatorProjectManager(this.jList2, this.moduleIndicatorProjectManager);
                this.jList2.setSelectedValue(projectName, true);
                return;
            }
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_module_indicator_name"), MessagesBundle.getString("warning_title_invalid_module_indicator_name"), 2);
        }
        return;
    }

    private void Save(boolean selectProjectAfterSave) {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.alertIndicatorSave(selectProjectAfterSave);
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.moduleIndicatorSave(selectProjectAfterSave);
        }
    }

    private void alertIndicatorSave(boolean selectProjectAfterSave) {
        String projectName = (String)this.jList1.getSelectedValue();
        this._alertIndicatorSave(projectName, selectProjectAfterSave);
    }

    private void _alertIndicatorSave(String projectName, boolean selectProjectAfterSave) {
        if (projectName == null) {
            while (true) {
                if ((projectName = JOptionPane.showInputDialog(this, (Object)MessagesBundle.getString("info_message_enter_save_alert_indicator_name"))) == null) {
                    return;
                }
                if ((projectName = projectName.trim()).length() == 0) {
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_alert_indicator_name"), MessagesBundle.getString("warning_title_you_need_to_specific_alert_indicator_name"), 2);
                    continue;
                }
                if (this.alertIndicatorProjectManager.contains(projectName)) {
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_an_alert_indicator_with_same_name"), MessagesBundle.getString("warning_title_already_an_alert_indicator_with_same_name"), 2);
                    continue;
                }
                IndicatorDefaultDrawing drawing = (IndicatorDefaultDrawing)this.view.getDrawing();
                if (this.alertIndicatorProjectManager.addProject(drawing, projectName)) {
                    this.syncJListWithIndicatorProjectManager(this.jList1, this.alertIndicatorProjectManager);
                    String output = MessageFormat.format(MessagesBundle.getString("info_message_file_saved_template"), projectName);
                    JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("info_title_file_saved"), 1);
                    if (selectProjectAfterSave) {
                        this.jList1.setSelectedValue(projectName, true);
                    }
                    return;
                }
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_alert_indicator_name"), MessagesBundle.getString("warning_title_invalid_alert_indicator_name"), 2);
            }
        }
        IndicatorDefaultDrawing drawing = (IndicatorDefaultDrawing)this.view.getDrawing();
        if (this.alertIndicatorProjectManager.addProject(drawing, projectName)) {
            this.syncJListWithIndicatorProjectManager(this.jList1, this.alertIndicatorProjectManager);
            String output = MessageFormat.format(MessagesBundle.getString("info_message_file_saved_template"), projectName);
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("info_title_file_saved"), 1);
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_alert_indicator_name"), MessagesBundle.getString("warning_title_invalid_alert_indicator_name"), 2);
        }
    }

    private void moduleIndicatorSave(boolean selectProjectAfterSave) {
        String projectName = (String)this.jList2.getSelectedValue();
        this._moduleIndicatorSave(projectName, selectProjectAfterSave);
    }

    private void _moduleIndicatorSave(String projectName, boolean selectProjectAfterSave) {
        if (projectName == null) {
            while (true) {
                if ((projectName = JOptionPane.showInputDialog(this, (Object)MessagesBundle.getString("info_message_enter_save_module_indicator_name"))) == null) {
                    return;
                }
                if ((projectName = projectName.trim()).length() == 0) {
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_module_indicator_name"), MessagesBundle.getString("warning_title_you_need_to_specific_module_indicator_name"), 2);
                    continue;
                }
                if (this.moduleIndicatorProjectManager.contains(projectName)) {
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_module_indicator_with_same_name"), MessagesBundle.getString("warning_title_already_a_module_indicator_with_same_name"), 2);
                    continue;
                }
                IndicatorDefaultDrawing drawing = (IndicatorDefaultDrawing)this.view.getDrawing();
                if (this.moduleIndicatorProjectManager.addProject(drawing, projectName)) {
                    this.syncJListWithIndicatorProjectManager(this.jList2, this.moduleIndicatorProjectManager);
                    String output = MessageFormat.format(MessagesBundle.getString("info_message_file_saved_template"), projectName);
                    JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("info_title_file_saved"), 1);
                    if (selectProjectAfterSave) {
                        this.jList2.setSelectedValue(projectName, true);
                    }
                    return;
                }
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_module_indicator_name"), MessagesBundle.getString("warning_title_invalid_module_indicator_name"), 2);
            }
        }
        IndicatorDefaultDrawing drawing = (IndicatorDefaultDrawing)this.view.getDrawing();
        if (this.moduleIndicatorProjectManager.addProject(drawing, projectName)) {
            this.syncJListWithIndicatorProjectManager(this.jList2, this.moduleIndicatorProjectManager);
            String output = MessageFormat.format(MessagesBundle.getString("info_message_file_saved_template"), projectName);
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("info_title_file_saved"), 1);
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_module_indicator_name"), MessagesBundle.getString("warning_title_invalid_module_indicator_name"), 2);
        }
    }

    private void Export() {
        if (!this.promptToSaveSignificantEdits()) {
            return;
        }
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.alertIndicatorExport();
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.moduleIndicatorExport();
        }
    }

    private void alertIndicatorExport() {
        String projectName = (String)this.jList1.getSelectedValue();
        if (projectName == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_alert_indicator"), MessagesBundle.getString("warning_title_you_must_select_alert_indicator"), 2);
            return;
        }
        OperatorIndicator operatorIndicator = this.alertIndicatorProjectManager.getOperatorIndicator(projectName);
        if (operatorIndicator != null && operatorIndicator.getType() != this.alertIndicatorProjectManager.getPreferredOperatorIndicatorType()) {
            String output = MessageFormat.format(MessagesBundle.getString("warning_message_you_may_not_export_invalid_indicator"), projectName);
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("warning_title_you_may_not_export_invalid_indicator"), 2);
            return;
        }
        File file = Utils.promptSaveZippedJFileChooser(projectName);
        if (file == null) {
            return;
        }
        this.alertIndicatorProjectManager.export(projectName, file);
    }

    private void moduleIndicatorExport() {
        String projectName = (String)this.jList2.getSelectedValue();
        if (projectName == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_module_indicator"), MessagesBundle.getString("warning_title_you_must_select_module_indicator"), 2);
            return;
        }
        OperatorIndicator operatorIndicator = this.moduleIndicatorProjectManager.getOperatorIndicator(projectName);
        if (operatorIndicator != null && operatorIndicator.getType() != this.moduleIndicatorProjectManager.getPreferredOperatorIndicatorType()) {
            String output = MessageFormat.format(MessagesBundle.getString("warning_message_you_may_not_export_invalid_indicator"), projectName);
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("warning_title_you_may_not_export_invalid_indicator"), 2);
            return;
        }
        File file = Utils.promptSaveZippedJFileChooser(projectName);
        if (file == null) {
            return;
        }
        this.moduleIndicatorProjectManager.export(projectName, file);
    }

    private void Delete(boolean confirmationDialog) {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.alertIndicatorDelete(confirmationDialog);
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.moduleIndicatorDelete(confirmationDialog);
        }
    }

    private void alertIndicatorDelete(boolean confirmationDialog) {
        String projectName = (String)this.jList1.getSelectedValue();
        if (projectName == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_alert_indicator"), MessagesBundle.getString("warning_title_you_must_select_alert_indicator"), 2);
            return;
        }
        if (confirmationDialog) {
            String output = MessageFormat.format(MessagesBundle.getString("question_message_delete_template"), projectName);
            int result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_delete"), 0, 3);
            if (result != 0) {
                return;
            }
        }
        this.alertIndicatorProjectManager.removeProject(projectName);
        this.syncJListWithIndicatorProjectManager(this.jList1, this.alertIndicatorProjectManager);
        if (this.alertIndicatorProjectManager.getNumOfProject() == 0) {
            this.setDrawing(this.createDrawing());
        }
    }

    private void moduleIndicatorDelete(boolean confirmationDialog) {
        String projectName = (String)this.jList2.getSelectedValue();
        if (projectName == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_module_indicator"), MessagesBundle.getString("warning_title_you_must_select_module_indicator"), 2);
            return;
        }
        if (confirmationDialog) {
            String output = MessageFormat.format(MessagesBundle.getString("question_message_delete_template"), projectName);
            int result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_delete"), 0, 3);
            if (result != 0) {
                return;
            }
        }
        this.moduleIndicatorProjectManager.removeProject(projectName);
        this.syncJListWithIndicatorProjectManager(this.jList2, this.moduleIndicatorProjectManager);
        if (this.moduleIndicatorProjectManager.getNumOfProject() == 0) {
            this.setDrawing(this.createDrawing());
        }
    }

    private void Rename() {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.alertIndicatorRename();
        } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.moduleIndicatorRename();
        }
    }

    private boolean isIndicatorDatabaseVisibleAndSelected() {
        int select = this.jList1.getSelectedIndex();
        return this.jTabbedPane1.getSelectedIndex() == 0 && select >= 0 && select < this.alertIndicatorProjectManager.getNumOfProject();
    }

    private boolean isModuleDatabaseVisibleAndSelected() {
        int select = this.jList2.getSelectedIndex();
        return this.jTabbedPane1.getSelectedIndex() == 1 && select >= 0 && select < this.moduleIndicatorProjectManager.getNumOfProject();
    }

    private void alertIndicatorRename() {
        block6: {
            block5: {
                String oldProjectName = (String)this.jList1.getSelectedValue();
                if (oldProjectName == null) {
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_alert_indicator"), MessagesBundle.getString("warning_title_you_must_select_alert_indicator"), 2);
                    return;
                }
                assert (this.alertIndicatorProjectManager.contains(oldProjectName));
                String newProjectName = null;
                while (true) {
                    if ((newProjectName = JOptionPane.showInputDialog(this, MessagesBundle.getString("info_message_enter_rename_alert_indicator_name"), oldProjectName)) == null) {
                        return;
                    }
                    if ((newProjectName = newProjectName.trim()).length() == 0) {
                        JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_alert_indicator_name"), MessagesBundle.getString("warning_title_you_need_to_specific_alert_indicator_name"), 2);
                        continue;
                    }
                    if (!this.alertIndicatorProjectManager.contains(newProjectName)) break;
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_an_alert_indicator_with_same_name"), MessagesBundle.getString("warning_title_already_an_alert_indicator_with_same_name"), 2);
                }
                if (!this.alertIndicatorProjectManager.renameProject(newProjectName, oldProjectName)) break block5;
                DefaultListModel defaultListModel = (DefaultListModel)this.jList1.getModel();
                defaultListModel.setElementAt(newProjectName, this.jList1.getSelectedIndex());
                this.saveAlertIndicatorProjectManager();
                if (this.listSelectionEx == null) break block6;
                this.listSelectionEx = ListSelectionEx.newInstance(this.listSelectionEx.list, newProjectName);
                break block6;
            }
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("error_message_unknown_error_during_renaming"), MessagesBundle.getString("error_title_unknown_error_during_renaming"), 0);
        }
    }

    private void moduleIndicatorRename() {
        String oldProjectName = (String)this.jList2.getSelectedValue();
        if (oldProjectName == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_module_indicator"), MessagesBundle.getString("warning_title_you_must_select_module_indicator"), 2);
            return;
        }
        assert (this.moduleIndicatorProjectManager.contains(oldProjectName));
        String newProjectName = null;
        while (true) {
            if ((newProjectName = JOptionPane.showInputDialog(this, MessagesBundle.getString("info_message_enter_rename_module_indicator_name"), oldProjectName)) == null) {
                return;
            }
            if ((newProjectName = newProjectName.trim()).length() == 0) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_module_indicator_name"), MessagesBundle.getString("warning_title_you_need_to_specific_module_indicator_name"), 2);
                continue;
            }
            if (!this.moduleIndicatorProjectManager.contains(newProjectName)) break;
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_module_indicator_with_same_name"), MessagesBundle.getString("warning_title_already_a_module_indicator_with_same_name"), 2);
        }
        if (this.moduleIndicatorProjectManager.renameProject(newProjectName, oldProjectName)) {
            DefaultListModel defaultListModel = (DefaultListModel)this.jList2.getModel();
            defaultListModel.setElementAt(newProjectName, this.jList2.getSelectedIndex());
            this.saveModuleIndicatorProjectManager();
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("error_message_unknown_error_during_renaming"), MessagesBundle.getString("error_title_unknown_error_during_renaming"), 0);
        }
    }

    private ImageIcon getImageIcon(String imageIcon) {
        return new ImageIcon(this.getClass().getResource(imageIcon));
    }

    private JPopupMenu getJListPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(GUIBundle.getString("New..."), this.getImageIcon("/images/16x16/filenew.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.New();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("Save"), this.getImageIcon("/images/16x16/filesave.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.Save(true);
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem(GUIBundle.getString("Install..."), this.getImageIcon("/images/16x16/download.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorPanel.this.Install();
            }
        });
        popup.add(menuItem);
        if (this.isIndicatorDatabaseVisibleAndSelected() || this.isModuleDatabaseVisibleAndSelected()) {
            menuItem = new JMenuItem(GUIBundle.getString("Export..."), this.getImageIcon("/images/16x16/upload.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    IndicatorPanel.this.Export();
                }
            });
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = new JMenuItem(GUIBundle.getString("Rename..."), this.getImageIcon("/images/16x16/edit.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    IndicatorPanel.this.Rename();
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem(GUIBundle.getString("Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    IndicatorPanel.this.Delete(true);
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.New();
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        String projectName = (String)this.jList2.getSelectedValue();
        if (projectName == null) {
            this.listSelectionEx = null;
            return;
        }
        IndicatorDefaultDrawing indicatorDefaultDrawing = this.moduleIndicatorProjectManager.getIndicatorDefaultDrawing(projectName);
        boolean userCancel = false;
        if (indicatorDefaultDrawing != null) {
            if (this.promptToSaveSignificantEdits(this.listSelectionEx)) {
                this.setDrawing((Drawing)indicatorDefaultDrawing);
            } else {
                userCancel = true;
            }
        } else if (this.promptToSaveSignificantEdits(this.listSelectionEx)) {
            String output = MessageFormat.format(MessagesBundle.getString("question_message_corrupted_file_remove_template"), projectName);
            if (JOptionPane.showConfirmDialog(this, output, MessagesBundle.getString("question_title_corrupted_file_remove"), 0) == 0) {
                this.Delete(false);
            } else {
                this.setDrawing(this.createDrawing());
            }
        } else {
            userCancel = true;
        }
        if (!userCancel) {
            this.jList1.clearSelection();
            this.listSelectionEx = ListSelectionEx.newInstance(this.jList2, projectName);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.Install();
    }

    private void Install() {
        if (!this.promptToSaveSignificantEdits()) {
            return;
        }
        Wizard wizard = this.getWizardDialog();
        int ret = wizard.showModalDialog(650, 400, true);
        if (ret != 0) {
            JList jList = this.getCurrentActiveJList();
            this.syncJListWithIndicatorProjectManager(jList, this.getCurrentActiveIndicatorProjectManager());
            if (jList.getModel().getSize() > 0 && jList.getSelectedIndex() < 0) {
                jList.setSelectedIndex(0);
            }
            return;
        }
        WizardModel wizardModel = wizard.getModel();
        WizardPanelDescriptor wizardSelectInstallIndicatorMethodDescriptor = wizardModel.getPanelDescriptor("WizardSelectInstallIndicatorMethodDescriptor");
        WizardSelectInstallIndicatorMethodJPanel wizardSelectInstallIndicatorMethodJPanel = (WizardSelectInstallIndicatorMethodJPanel)wizardSelectInstallIndicatorMethodDescriptor.getPanelComponent();
        if (wizardSelectInstallIndicatorMethodJPanel.isLocalFileSelected()) {
            File file = wizardSelectInstallIndicatorMethodJPanel.getSelectedFile();
            assert (file != null);
            if (this.jTabbedPane1.getSelectedIndex() == 0) {
                this.alertIndicatorInstall(file);
            } else if (this.jTabbedPane1.getSelectedIndex() == 1) {
                this.moduleIndicatorInstall(file);
            }
        } else {
            JList jList = this.getCurrentActiveJList();
            this.syncJListWithIndicatorProjectManager(jList, this.getCurrentActiveIndicatorProjectManager());
            if (jList.getModel().getSize() > 0 && jList.getSelectedIndex() < 0) {
                jList.setSelectedIndex(0);
            }
        }
    }

    private void alertIndicatorInstall(File file) {
        IndicatorProjectManager.PreInstallStatus preInstallStatus = this.alertIndicatorProjectManager.getPreInstallStatus(file);
        if (preInstallStatus == IndicatorProjectManager.PreInstallStatus.Collision) {
            String output = MessageFormat.format(MessagesBundle.getString("question_message_do_you_want_to_overwrite_template"), IndicatorProjectManager.getProjectName(file));
            if (JOptionPane.showConfirmDialog(this, output, MessagesBundle.getString("question_title_do_you_want_to_overwrite"), 0) == 1) {
                return;
            }
        } else if (preInstallStatus == IndicatorProjectManager.PreInstallStatus.Unsafe) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_alert_indicator_file"), MessagesBundle.getString("warning_title_invalid_alert_indicator_file"), 2);
            return;
        }
        if (this.alertIndicatorProjectManager.install(file)) {
            this.syncJListWithIndicatorProjectManager(this.jList1, this.alertIndicatorProjectManager);
            this.jList1.setSelectedValue(IndicatorProjectManager.getProjectName(file), true);
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_alert_indicator_file"), MessagesBundle.getString("warning_title_invalid_alert_indicator_file"), 2);
        }
    }

    private void moduleIndicatorInstall(File file) {
        IndicatorProjectManager.PreInstallStatus preInstallStatus = this.moduleIndicatorProjectManager.getPreInstallStatus(file);
        if (preInstallStatus == IndicatorProjectManager.PreInstallStatus.Collision) {
            String output = MessageFormat.format(MessagesBundle.getString("question_message_do_you_want_to_overwrite_template"), IndicatorProjectManager.getProjectName(file));
            if (JOptionPane.showConfirmDialog(this, output, MessagesBundle.getString("question_title_do_you_want_to_overwrite"), 0) == 1) {
                return;
            }
        } else if (preInstallStatus == IndicatorProjectManager.PreInstallStatus.Unsafe) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_module_indicator_file"), MessagesBundle.getString("warning_title_invalid_module_indicator_file"), 2);
            return;
        }
        if (this.moduleIndicatorProjectManager.install(file)) {
            this.syncJListWithIndicatorProjectManager(this.jList2, this.moduleIndicatorProjectManager);
            this.jList2.setSelectedValue(IndicatorProjectManager.getProjectName(file), true);
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_module_indicator_file"), MessagesBundle.getString("warning_title_invalid_module_indicator_file"), 2);
        }
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"org.yccheok.jstock.data.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle((String)"org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo((JToolBar)tb, (DrawingEditor)editor, IndicatorPanel.createDrawingActions(editor), IndicatorPanel.createSelectionActions(editor));
        tb.addSeparator();
        HashMap<Object, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.FILL_COLOR, Color.white);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        attributes.put(AttributeKeys.TEXT_COLOR, Color.black);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.LogicalOperatorFigure", attributes), (String)"createLogical", (ResourceBundleUtil)labels);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.EqualityOperatorFigure", attributes), (String)"createEquality", (ResourceBundleUtil)labels);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.ArithmeticOperatorFigure", attributes), (String)"createArithmetic", (ResourceBundleUtil)labels);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.FunctionOperatorFigure", attributes), (String)"createFunction", (ResourceBundleUtil)labels);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.DoubleConstantOperatorFigure", attributes), (String)"createDoubleConstant", (ResourceBundleUtil)labels);
        tb.addSeparator();
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.StockRelativeHistoryOperatorFigure", attributes), (String)"createStockRelativeHistory", (ResourceBundleUtil)labels);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.StockHistoryOperatorFigure", attributes), (String)"createStockHistory", (ResourceBundleUtil)labels);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.StockOperatorFigure", attributes), (String)"createStock", (ResourceBundleUtil)labels);
        tb.addSeparator();
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new OperatorFigureCreationTool("org.yccheok.jstock.gui.analysis.SinkOperatorFigure", attributes), (String)"createSink", (ResourceBundleUtil)labels);
        tb.addSeparator();
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        attributes.put(AttributeKeys.TEXT_COLOR, Color.black);
        attributes.put(AttributeKeys.FONT_BOLD, true);
        attributes.put(AttributeKeys.FILL_COLOR, new Color(255, 204, 0));
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)new TextAreaCreationTool((TextHolderFigure)new TextAreaFigure(), attributes), (String)"edit.createText", (ResourceBundleUtil)drawLabels);
    }

    private static Collection<Action> createDrawingActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        return a;
    }

    private static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add((Action)((Object)new PropertiesAction(editor)));
        a.add(null);
        a.add((Action)((Object)new DeleteAction(editor)));
        return a;
    }

    public void initAjaxProvider() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        Country country = jStockOptions.getCountry();
        AutoCompleteJComboBox autoCompleteJComboBox = (AutoCompleteJComboBox)this.jComboBox1;
        if (country == Country.India) {
            autoCompleteJComboBox.setGreedyEnabled(true, Arrays.asList("N", "B"));
        } else if (country == Country.Japan) {
            autoCompleteJComboBox.setGreedyEnabled(false, Collections.emptyList());
        } else {
            autoCompleteJComboBox.setGreedyEnabled(false, Collections.emptyList());
        }
    }

    public void setStockInfoDatabase(StockInfoDatabase stockInfoDatabase) {
        ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(stockInfoDatabase);
    }

    private void addStockInfoFromAutoCompleteJComboBox(StockInfo stockInfo) {
        StockTask tmp = this.stockTask;
        if (tmp != null) {
            tmp.cancel(true);
        }
        this.stockTask = new StockTask(stockInfo.code, stockInfo.symbol);
        this.stockTask.execute();
    }

    private Observer<AutoCompleteJComboBox, DispType> getDispObserver() {
        return new Observer<AutoCompleteJComboBox, DispType>(){

            @Override
            public void update(AutoCompleteJComboBox subject, DispType dispType) {
                assert (dispType != null);
                Code code = Code.newInstance(dispType.getDispCode());
                Symbol symbol = Symbol.newInstance(dispType.getDispName());
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                IndicatorPanel.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
            }
        };
    }

    private Observer<AutoCompleteJComboBox, StockInfo> getStockInfoObserver() {
        return new Observer<AutoCompleteJComboBox, StockInfo>(){

            @Override
            public void update(AutoCompleteJComboBox subject, StockInfo stockInfo) {
                assert (stockInfo != null);
                IndicatorPanel.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
            }
        };
    }

    public void dettachAllAndStopAutoCompleteJComboBox() {
        ((AutoCompleteJComboBox)this.jComboBox1).dettachAll();
        ((AutoCompleteJComboBox)this.jComboBox1).stop();
    }

    private void stop() {
        StockTask tmp = this.stockTask;
        if (tmp != null) {
            tmp.cancel(true);
            this.stockTask = null;
            log.info((Object)"Terminated stock task");
        }
        Thread thread = this.simulationThread;
        this.simulationThread = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException exp) {
                log.error(null, (Throwable)exp);
            }
            log.info((Object)"Terminated simulation thread");
        }
    }

    private void createToolTipTextForJTabbedPane() {
        this.jTabbedPane1.setToolTipTextAt(0, GUIBundle.getString("IndicatorPanel_AlertIndicatorToolTip"));
    }

    private void simulate(final Stock stock) {
        JStock m = JStock.instance();
        IndicatorDefaultDrawing indicatorDefaultDrawing = (IndicatorDefaultDrawing)this.view.getDrawing();
        OperatorIndicator operatorIndicator = indicatorDefaultDrawing.getOperatorIndicator();
        Duration historyDuration = operatorIndicator.getNeededStockHistoryDuration();
        Thread currentThread = Thread.currentThread();
        if (stock != null && operatorIndicator.isStockHistoryServerNeeded()) {
            StockHistoryServer stockHistoryServer;
            m.setStatusBar(true, MessagesBundle.getString("info_message_stock_history_retrieving_in_progress..."));
            Duration oldDuration = this.stockHistoryMonitor.getDuration();
            if (oldDuration == null || !oldDuration.equals(historyDuration)) {
                this.initStockHistoryMonitor();
                this.stockHistoryMonitor.setDuration(historyDuration);
            }
            if ((stockHistoryServer = this.stockHistoryMonitor.getStockHistoryServer(stock.code)) == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> observer = new Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable>(){

                    @Override
                    public void update(StockHistoryMonitor monitor, StockHistoryMonitor.StockHistoryRunnable runnable) {
                        if (runnable.getCode().equals(stock.code)) {
                            countDownLatch.countDown();
                        }
                    }
                };
                this.stockHistoryMonitor.attach(observer);
                this.stockHistoryMonitor.addStockCode(stock.code);
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException exp) {
                    log.error(null, (Throwable)exp);
                    return;
                }
                this.stockHistoryMonitor.dettach(observer);
                stockHistoryServer = this.stockHistoryMonitor.getStockHistoryServer(stock.code);
            }
            if (stockHistoryServer == null) {
                this.jButton4.setEnabled(true);
                this.jButton6.setEnabled(false);
                m.setStatusBar(false, MessagesBundle.getString("info_message_history_not_found"));
                return;
            }
            if (currentThread.isInterrupted() || this.simulationThread != currentThread) {
                return;
            }
            m.setStatusBar(true, MessagesBundle.getString("info_message_stock_history_information_calculation_in_progress..."));
            operatorIndicator.setStockHistoryServer(stockHistoryServer);
        }
        if (currentThread.isInterrupted() || this.simulationThread != currentThread) {
            return;
        }
        m.setStatusBar(true, MessagesBundle.getString("info_message_real_time_stock_information_calculation_in_progress..."));
        operatorIndicator.preCalculate();
        if (currentThread.isInterrupted() || this.simulationThread != currentThread) {
            return;
        }
        m.setStatusBar(true, MessagesBundle.getString("info_message_final_calculation..."));
        long startTime = System.nanoTime();
        if (stock != null) {
            operatorIndicator.setStock(stock);
        }
        operatorIndicator.isTriggered();
        long estimatedTime = System.nanoTime() - startTime;
        if (currentThread.isInterrupted() || this.simulationThread != currentThread) {
            return;
        }
        String output = MessageFormat.format(MessagesBundle.getString("info_message_simulation_done_with_time_taken_template"), (double)estimatedTime / 1000000.0);
        m.setStatusBar(false, output);
        this.jButton4.setEnabled(true);
        this.jButton6.setEnabled(false);
    }

    public final void initIndicatorProjectManager() {
        File[] files;
        File f = new File(Utils.getUserDataDirectory() + "indicator" + File.separator + "project.xml");
        this.alertIndicatorProjectManager = Utils.fromXML(IndicatorProjectManager.class, f);
        if (this.alertIndicatorProjectManager != null) {
            log.info((Object)("alertIndicatorProjectManager loaded from " + f.toString() + " successfully."));
        } else {
            this.alertIndicatorProjectManager = new IndicatorProjectManager(Utils.getUserDataDirectory() + "indicator", OperatorIndicator.Type.AlertIndicator);
        }
        HashSet<String> validFileNames = new HashSet<String>();
        int size = this.alertIndicatorProjectManager.getNumOfProject();
        for (int i = 0; i < size; ++i) {
            String PROJECTNAME = this.alertIndicatorProjectManager.getProject(i).toUpperCase();
            validFileNames.add(PROJECTNAME + ".XML");
            validFileNames.add(PROJECTNAME + "-JHOTDRAW.XML");
        }
        validFileNames.add("PROJECT.XML");
        for (File file : files = new File(Utils.getUserDataDirectory() + "indicator" + File.separator).listFiles()) {
            if (validFileNames.contains(file.getName().toUpperCase())) continue;
            file.delete();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)IndicatorPanel.this.jList1.getModel();
                defaultListModel.clear();
                for (int i = 0; i < IndicatorPanel.this.alertIndicatorProjectManager.getNumOfProject(); ++i) {
                    defaultListModel.addElement(IndicatorPanel.this.alertIndicatorProjectManager.getProject(i));
                }
                if (IndicatorPanel.this.jList1.getModel().getSize() > 0) {
                    IndicatorPanel.this.jList1.setSelectedIndex(0);
                }
            }
        });
    }

    public final void initModuleProjectManager() {
        File f = new File(Utils.getUserDataDirectory() + "module" + File.separator + "project.xml");
        this.moduleIndicatorProjectManager = Utils.fromXML(IndicatorProjectManager.class, f);
        if (this.moduleIndicatorProjectManager != null) {
            log.info((Object)("moduleIndicatorProjectManager loaded from " + f.toString() + " successfully."));
        } else {
            this.moduleIndicatorProjectManager = new IndicatorProjectManager(Utils.getUserDataDirectory() + "module", OperatorIndicator.Type.ModuleIndicator);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)IndicatorPanel.this.jList2.getModel();
                defaultListModel.clear();
                for (int i = 0; i < IndicatorPanel.this.moduleIndicatorProjectManager.getNumOfProject(); ++i) {
                    defaultListModel.addElement(IndicatorPanel.this.moduleIndicatorProjectManager.getProject(i));
                }
            }
        });
    }

    public boolean saveModuleIndicatorProjectManager() {
        File f = new File(Utils.getUserDataDirectory() + "module" + File.separator + "project.xml");
        return Utils.toXML((Object)this.moduleIndicatorProjectManager, f);
    }

    public boolean saveAlertIndicatorProjectManager() {
        File f = new File(Utils.getUserDataDirectory() + "indicator" + File.separator + "project.xml");
        return Utils.toXML((Object)this.alertIndicatorProjectManager, f);
    }

    public IndicatorProjectManager getAlertIndicatorProjectManager() {
        return this.alertIndicatorProjectManager;
    }

    public IndicatorProjectManager getModuleIndicatorProjectManager() {
        return this.moduleIndicatorProjectManager;
    }

    public void initStockHistoryMonitor() {
        final StockHistoryMonitor oldStockHistoryMonitor = this.stockHistoryMonitor;
        if (oldStockHistoryMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldStockHistoryMonitor + "..."));
                    oldStockHistoryMonitor.clearStockCodes();
                    oldStockHistoryMonitor.dettachAll();
                    oldStockHistoryMonitor.stop();
                    log.info((Object)("Shut down " + oldStockHistoryMonitor + " peacefully."));
                }
            });
        }
        this.stockHistoryMonitor = new StockHistoryMonitor(1);
        this.stockHistoryMonitor.setStockHistorySerializer(new StockHistorySerializer(Utils.getHistoryDirectory()));
    }

    private JList getCurrentActiveJList() {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            return this.jList1;
        }
        assert (this.jTabbedPane1.getSelectedIndex() == 1);
        return this.jList2;
    }

    private IndicatorProjectManager getCurrentActiveIndicatorProjectManager() {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            return this.alertIndicatorProjectManager;
        }
        assert (this.jTabbedPane1.getSelectedIndex() == 1);
        return this.moduleIndicatorProjectManager;
    }

    private Wizard getWizardDialog() {
        JStock m = JStock.instance();
        Wizard wizard = new Wizard(m);
        wizard.getDialog().setTitle(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("IndicatorPanel_IndicatorInstallWizard"));
        wizard.getDialog().setResizable(false);
        WizardSelectInstallIndicatorMethodDescriptor wizardSelectInstallIndicatorMethodDescriptor = new WizardSelectInstallIndicatorMethodDescriptor();
        wizard.registerWizardPanel("WizardSelectInstallIndicatorMethodDescriptor", wizardSelectInstallIndicatorMethodDescriptor);
        wizard.setCurrentPanel("WizardSelectInstallIndicatorMethodDescriptor");
        WizardSelectIndicatorDescriptor wizardSelectIndicatorDescriptor = new WizardSelectIndicatorDescriptor(this.getCurrentActiveIndicatorProjectManager());
        wizard.registerWizardPanel("WizardSelectIndicatorDescriptor", wizardSelectIndicatorDescriptor);
        WizardDownloadIndicatorDescriptor wizardDownloadIndicatorDescriptor = new WizardDownloadIndicatorDescriptor(this.getCurrentActiveIndicatorProjectManager());
        wizard.registerWizardPanel("WizardDownloadIndicatorDescriptor", wizardDownloadIndicatorDescriptor);
        wizard.getDialog().setLocationRelativeTo(null);
        wizard.getDialog().setSize(200, 200);
        return wizard;
    }

    private void initListCellRenderer() {
        assert (this.moduleIndicatorProjectManager != null);
        assert (this.alertIndicatorProjectManager != null);
        assert (this.jList1 != null);
        assert (this.jList2 != null);
        this.jList1.setCellRenderer(this.getListCellRenderer(this.alertIndicatorProjectManager));
        this.jList2.setCellRenderer(this.getListCellRenderer(this.moduleIndicatorProjectManager));
    }

    private ListCellRenderer getListCellRenderer(final IndicatorProjectManager projectManager) {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                OperatorIndicator operatorIndicator;
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component != null && value != null && (operatorIndicator = projectManager.getOperatorIndicator(value.toString())) != null && operatorIndicator.getType() != projectManager.getPreferredOperatorIndicatorType()) {
                    Font oldFont = component.getFont();
                    component.setFont(oldFont.deriveFont(oldFont.getStyle() | 2));
                }
                return component;
            }
        };
    }

    private void syncJListWithIndicatorProjectManager(JList jList, IndicatorProjectManager indicatorProjectManager) {
        int i;
        String projectName = (String)jList.getSelectedValue();
        boolean isProjectNameBeingRemoved = false;
        int newSelection = -1;
        ListModel listModel = jList.getModel();
        for (i = 0; i < listModel.getSize(); ++i) {
            if (indicatorProjectManager.contains(listModel.getElementAt(i).toString())) continue;
            Object removedObject = ((DefaultListModel)listModel).remove(i);
            if (projectName.equals(removedObject)) {
                isProjectNameBeingRemoved = true;
                newSelection = i;
            }
            --i;
        }
        for (i = 0; i < indicatorProjectManager.getNumOfProject(); ++i) {
            String p = indicatorProjectManager.getProject(i);
            if (((DefaultListModel)listModel).contains(p)) continue;
            ((DefaultListModel)listModel).addElement(p);
        }
        if (!isProjectNameBeingRemoved) {
            jList.setSelectedValue(projectName, true);
        } else if (newSelection >= jList.getModel().getSize()) {
            jList.setSelectedIndex(jList.getModel().getSize() - 1);
        } else {
            jList.setSelectedIndex(newSelection);
        }
    }

    private class StockTask
    extends SwingWorker<Boolean, Stock> {
        final Code code;
        final Symbol symbol;

        public StockTask(Code code, Symbol symbol) {
            this.code = code;
            this.symbol = symbol;
        }

        @Override
        public Boolean doInBackground() {
            Boolean success = false;
            Stock s = null;
            int tries = 0;
            JStock m = JStock.instance();
            if (m == null) {
                this.publish(s);
                return success;
            }
            m.setStatusBar(true, GUIBundle.getString("IndicatorPanel_StockSampleDataRetrievingInProgress..."));
            while (!this.isCancelled() && !success.booleanValue()) {
                for (StockServerFactory factory : Factories.INSTANCE.getStockServerFactories(this.code)) {
                    StockServer server = factory.getStockServer();
                    if (server == null) continue;
                    s = server.getStock(this.code);
                    if (s != null) {
                        success = true;
                        break;
                    }
                    if (!this.isCancelled()) continue;
                    break;
                }
                if (++tries < 3) continue;
            }
            this.publish(s);
            return success;
        }

        @Override
        protected void process(List<Stock> stocks) {
            for (Stock stock : stocks) {
                if (this.isCancelled()) {
                    return;
                }
                JStock m = JStock.instance();
                if (stock != null) {
                    String _name;
                    StockNameDatabase stockNameDatabase;
                    Symbol _symbol;
                    StockInfoDatabase stockInfoDatabase;
                    Stock new_stock = stock;
                    if ((org.yccheok.jstock.engine.Utils.isSymbolImmutable() || new_stock.symbol.toString().isEmpty()) && (stockInfoDatabase = m.getStockInfoDatabase()) != null && (_symbol = stockInfoDatabase.codeToSymbol(new_stock.code)) != null) {
                        new_stock = new_stock.deriveStock(_symbol);
                    }
                    if (org.yccheok.jstock.engine.Utils.isNameImmutable() && (stockNameDatabase = m.getStockNameDatabase()) != null && (_name = stockNameDatabase.codeToName(new_stock.code)) != null) {
                        new_stock = new_stock.deriveStock(_name);
                    }
                    ((ObjectInspectorJPanel)((Object)IndicatorPanel.this.objectInspectorJPanel)).setBean(new MutableStock(new_stock));
                    if (m == null) continue;
                    m.setStatusBar(false, GUIBundle.getString("IndicatorPanel_StockSampleDataRetrievedSuccess"));
                    continue;
                }
                if (m == null) continue;
                m.setStatusBar(false, GUIBundle.getString("IndicatorPanel_StockSampleDataRetrievedFailed"));
            }
        }
    }

    private class JListPopupListener
    extends MouseAdapter {
        private JListPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                IndicatorPanel.this.getJListPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class ListSelectionEx {
        public final JList list;
        public final String projectName;

        private ListSelectionEx(JList list, String projectName) {
            if (list == null || projectName == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.list = list;
            this.projectName = projectName;
        }

        public static ListSelectionEx newInstance(JList list, String projectName) {
            return new ListSelectionEx(list, projectName);
        }
    }
}

