/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.AjaxYahooSearchEngine;
import org.yccheok.jstock.engine.ResultSetType;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.Subject;

public class AjaxYahooSearchEngineMonitor
extends Subject<AjaxYahooSearchEngineMonitor, ResultSetType> {
    private final SearchEngine<ResultType> searchEngine = new AjaxYahooSearchEngine();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<String> blockingQueue = new ArrayBlockingQueue<String>(128);
    private static final Log log = LogFactory.getLog(AjaxYahooSearchEngineMonitor.class);

    public AjaxYahooSearchEngineMonitor() {
        this.executor.execute(new SearchTask());
    }

    public synchronized void clearAndPut(String string) {
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Executor is shutdown.");
        }
        this.blockingQueue.clear();
        try {
            this.blockingQueue.put(string);
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    public void stop() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(100L, TimeUnit.DAYS);
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private class SearchTask
    implements Runnable {
        private SearchTask() {
        }

        @Override
        public void run() {
            while (!AjaxYahooSearchEngineMonitor.this.executor.isShutdown()) {
                try {
                    String string = (String)AjaxYahooSearchEngineMonitor.this.blockingQueue.take();
                    List<ResultType> results = AjaxYahooSearchEngineMonitor.this.searchEngine.searchAll(string);
                    ResultSetType resultSet = ResultSetType.newInstance(string, results);
                    AjaxYahooSearchEngineMonitor.this.notify(AjaxYahooSearchEngineMonitor.this, resultSet);
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                    break;
                }
            }
        }
    }
}

