/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.AbstractOperator;

public class EqualityOperator
extends AbstractOperator {
    private Equality equality = Equality.Equal;
    private static final Log log = LogFactory.getLog(EqualityOperator.class);

    @Override
    protected Object calculate() {
        Object object0 = this.inputs[0].getValue();
        Object object1 = this.inputs[1].getValue();
        try {
            Double d0 = Double.parseDouble(object0.toString());
            Double d1 = Double.parseDouble(object1.toString());
            int result = d0.compareTo(d1);
            switch (this.equality) {
                case Equal: {
                    return result == 0;
                }
                case Greater: {
                    return result > 0;
                }
                case Lesser: {
                    return result < 0;
                }
                case GreaterOrEqual: {
                    return result >= 0;
                }
                case LesserOrEqual: {
                    return result <= 0;
                }
            }
            assert (false);
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
        }
        return null;
    }

    @Override
    public int getNumOfInputConnector() {
        return 2;
    }

    public Equality getEquality() {
        return this.equality;
    }

    public void setEquality(Equality equality) {
        Equality old = this.equality;
        this.equality = equality;
        if (old != this.equality) {
            this.firePropertyChange("attribute", (Object)old, (Object)this.equality);
        }
    }

    @Override
    public Class getInputClass(int index) {
        return Double.class;
    }

    @Override
    public Class getOutputClass(int index) {
        return Boolean.class;
    }

    public static enum Equality {
        Equal,
        Greater,
        Lesser,
        GreaterOrEqual,
        LesserOrEqual;

    }
}

