/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.gui.error.DThrowable;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class DViewPEM
extends PortecleJDialog {
    private final Object m_object;
    private String m_pem;
    private final JFileChooser m_chooser;

    public DViewPEM(Window window, String string, Object object, JFileChooser jFileChooser) throws CryptoException {
        super(window, string, true);
        this.m_object = object;
        this.m_chooser = jFileChooser;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        Serializable serializable;
        Object object;
        Object object2;
        if (this.m_pem == null) {
            object2 = new StringWriter();
            try {
                object = new JcaPEMWriter((Writer)object2);
                serializable = null;
                try {
                    ((JcaPEMWriter)object).writeObject(this.m_object);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (serializable != null) {
                            try {
                                ((BufferedWriter)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            ((BufferedWriter)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new CryptoException(FPortecle.RB.getString("DViewPEM.exception.message"), iOException);
            }
            this.m_pem = ((StringWriter)object2).toString();
        }
        object2 = new JPanel(new FlowLayout(1));
        object = this.getOkButton(true);
        serializable = new JButton(FPortecle.RB.getString("DViewPEM.jbSave.text"));
        ((AbstractButton)serializable).setMnemonic(FPortecle.RB.getString("DViewPEM.jbSave.mnemonic").charAt(0));
        if (this.m_chooser == null || this.m_pem == null) {
            ((AbstractButton)serializable).setEnabled(false);
        } else {
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DViewPEM.this.savePressed();
                }
            });
        }
        ((Container)object2).add((Component)object);
        ((Container)object2).add((Component)serializable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTextArea jTextArea = new JTextArea(this.m_pem);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, jTextArea.getFont().getSize()));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)object2, "South");
        this.getRootPane().setDefaultButton((JButton)object);
        this.initDialog();
        this.setResizable(true);
        ((JComponent)object).requestFocusInWindow();
    }

    private void savePressed() {
        int n = this.m_chooser.showDialog(this, FPortecle.RB.getString("DViewPEM.jbSave.text"));
        if (n == 0) {
            Object object;
            int n2;
            File file = this.m_chooser.getSelectedFile();
            if (file.isFile() && (n2 = JOptionPane.showConfirmDialog(this, object = MessageFormat.format(FPortecle.RB.getString("DViewPEM.OverWriteFile.message"), file.getName()), this.getTitle(), 0)) == 1) {
                return;
            }
            try {
                object = new FileWriter(file);
                Throwable throwable = null;
                try {
                    ((Writer)object).write(this.m_pem);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStreamWriter)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStreamWriter)object).close();
                        }
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = MessageFormat.format(FPortecle.RB.getString("DViewPEM.NoWriteFile.message"), file.getName());
                JOptionPane.showMessageDialog(this, string, this.getTitle(), 2);
            }
            catch (IOException iOException) {
                DThrowable.showAndWait(this, null, iOException);
            }
        }
    }
}

