/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DocumentMaxLengthFilter
extends DocumentFilter {
    private final int maxLength;

    public DocumentMaxLengthFilter(int n) {
        this.maxLength = n;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            super.insertString(filterBypass, n, string, attributeSet);
            return;
        }
        if (filterBypass.getDocument().getLength() + n2 > this.maxLength) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(filterBypass, n, string, attributeSet);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        int n3;
        if (string == null || (n3 = string.length()) == 0) {
            super.replace(filterBypass, n, n2, string, attributeSet);
            return;
        }
        int n4 = n3 - n2;
        if (filterBypass.getDocument().getLength() + n4 > this.maxLength) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.replace(filterBypass, n, n2, string, attributeSet);
    }
}

