/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.FileChooserFactory;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.AlgorithmType;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.KeyPairUtil;
import net.sf.portecle.crypto.NameUtil;
import net.sf.portecle.crypto.SignatureType;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.crypto.DViewPEM;
import net.sf.portecle.gui.error.DThrowable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

class DViewCSR
extends PortecleJDialog {
    private JTextField m_jtfVersion;
    private JTextField m_jtfSubject;
    private JTextField m_jtfPublicKey;
    private JTextField m_jtfSignatureAlgorithm;
    private final PKCS10CertificationRequest m_req;
    private String m_basename;

    public DViewCSR(Window window, String string, PKCS10CertificationRequest pKCS10CertificationRequest) throws CryptoException {
        super(window, string, true);
        this.m_req = pKCS10CertificationRequest;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DViewCSR.jlVersion.text"));
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = 0;
        this.m_jtfVersion = new JTextField(3);
        this.m_jtfVersion.setEditable(false);
        this.m_jtfVersion.setToolTipText(FPortecle.RB.getString("DViewCSR.m_jtfVersion.tooltip"));
        jLabel.setLabelFor(this.m_jtfVersion);
        GridBagConstraints gridBagConstraints4 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints4.gridy = 0;
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DViewCSR.jlSubject.text"));
        GridBagConstraints gridBagConstraints5 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints5.gridy = 1;
        this.m_jtfSubject = new JTextField(36);
        this.m_jtfSubject.setEditable(false);
        this.m_jtfSubject.setToolTipText(FPortecle.RB.getString("DViewCSR.m_jtfSubject.tooltip"));
        jLabel2.setLabelFor(this.m_jtfSubject);
        GridBagConstraints gridBagConstraints6 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints6.gridy = 1;
        JLabel jLabel3 = new JLabel(FPortecle.RB.getString("DViewCSR.jlPublicKey.text"));
        GridBagConstraints gridBagConstraints7 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints7.gridy = 6;
        this.m_jtfPublicKey = new JTextField(15);
        this.m_jtfPublicKey.setEditable(false);
        this.m_jtfPublicKey.setToolTipText(FPortecle.RB.getString("DViewCSR.m_jtfPublicKey.tooltip"));
        jLabel3.setLabelFor(this.m_jtfPublicKey);
        GridBagConstraints gridBagConstraints8 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints8.gridy = 6;
        JLabel jLabel4 = new JLabel(FPortecle.RB.getString("DViewCSR.jlSignatureAlgorithm.text"));
        GridBagConstraints gridBagConstraints9 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints9.gridy = 7;
        this.m_jtfSignatureAlgorithm = new JTextField(15);
        this.m_jtfSignatureAlgorithm.setEditable(false);
        this.m_jtfSignatureAlgorithm.setToolTipText(FPortecle.RB.getString("DViewCSR.m_jtfSignatureAlgorithm.tooltip"));
        jLabel4.setLabelFor(this.m_jtfSignatureAlgorithm);
        GridBagConstraints gridBagConstraints10 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints10.gridy = 7;
        JButton jButton = new JButton(FPortecle.RB.getString("DViewCSR.jbPemEncoding.text"));
        jButton.setMnemonic(FPortecle.RB.getString("DViewCSR.jbPemEncoding.mnemonic").charAt(0));
        jButton.setToolTipText(FPortecle.RB.getString("DViewCSR.jbPemEncoding.tooltip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCSR.this.pemEncodingPressed();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 10;
        gridBagConstraints11.gridwidth = 2;
        gridBagConstraints11.gridheight = 1;
        gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints11.anchor = 13;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        jPanel2.add((Component)jLabel, gridBagConstraints3);
        jPanel2.add((Component)this.m_jtfVersion, gridBagConstraints4);
        jPanel2.add((Component)jLabel2, gridBagConstraints5);
        jPanel2.add((Component)this.m_jtfSubject, gridBagConstraints6);
        jPanel2.add((Component)jLabel3, gridBagConstraints7);
        jPanel2.add((Component)this.m_jtfPublicKey, gridBagConstraints8);
        jPanel2.add((Component)jLabel4, gridBagConstraints9);
        jPanel2.add((Component)this.m_jtfSignatureAlgorithm, gridBagConstraints10);
        jPanel2.add((Component)jPanel, gridBagConstraints11);
        this.populateDialog();
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        JButton jButton2 = this.getOkButton(true);
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.initDialog();
        jButton2.requestFocusInWindow();
    }

    private void populateDialog() throws CryptoException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        this.m_jtfVersion.setText(this.m_req.toASN1Structure().getCertificationRequestInfo().getVersion().getValue().toString());
        this.m_jtfVersion.setCaretPosition(0);
        X500Name x500Name = this.m_req.getSubject();
        this.m_jtfSubject.setText(x500Name.toString());
        this.m_jtfSubject.setCaretPosition(0);
        this.m_basename = NameUtil.getCommonName(x500Name);
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.m_req.getSubjectPublicKeyInfo();
        try {
            asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (IOException iOException) {
            throw new CryptoException(FPortecle.RB.getString("DViewCSR.NoGetKeyInfo.exception.message"), iOException);
        }
        this.m_jtfPublicKey.setText(AlgorithmType.toString(subjectPublicKeyInfo.getAlgorithm().getAlgorithm().toString()));
        int n = KeyPairUtil.getKeyLength(asymmetricKeyParameter);
        if (n != -1) {
            this.m_jtfPublicKey.setText(MessageFormat.format(FPortecle.RB.getString("DViewCSR.m_jtfPublicKey.text"), this.m_jtfPublicKey.getText(), n));
        }
        this.m_jtfPublicKey.setCaretPosition(0);
        String string = SignatureType.toString(this.m_req.getSignatureAlgorithm().getAlgorithm().toString());
        this.m_jtfSignatureAlgorithm.setText(string);
        this.m_jtfSignatureAlgorithm.setCaretPosition(0);
    }

    private void pemEncodingPressed() {
        JFileChooser jFileChooser = FileChooserFactory.getCsrFileChooser(this.m_basename);
        jFileChooser.setDialogTitle(FPortecle.RB.getString("DViewCSR.Save.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        try {
            DViewPEM dViewPEM = new DViewPEM((Window)this, FPortecle.RB.getString("DViewCSR.PemEncoding.Title"), this.m_req, jFileChooser);
            dViewPEM.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dViewPEM);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
        }
    }
}

