/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class I18nProps {
    private File _file;
    private File _zipFile;
    private String _entryName;
    private String _name;

    public I18nProps(File file, URL[] sourceUrls) {
        this._file = file;
        this.initName(sourceUrls);
    }

    public I18nProps(File zipFile, String entryName, URL[] sourceUrls) {
        this._zipFile = zipFile;
        this._entryName = entryName;
        this.initName(sourceUrls);
    }

    private void initName(URL[] sourceUrls) {
        for (int i = 0; i < sourceUrls.length; ++i) {
            String classPathEntry = sourceUrls[i].getPath().replaceAll("%20", " ");
            if (!this.getPath().startsWith(classPathEntry)) continue;
            this._name = this.getPath().substring(classPathEntry.length());
            return;
        }
        this._name = this.getPath();
    }

    public String getPath() {
        try {
            if (null != this._file) {
                return this._file.toURI().toURL().getPath().replaceAll("%20", " ");
            }
            return new File(this._zipFile.toString() + File.separator + this._entryName).toURI().toURL().getPath().replaceAll("%20", " ");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this._name;
    }

    Properties getProperties() {
        try {
            Properties ret = new Properties();
            InputStream is = this.getInputStream();
            ret.load(is);
            is.close();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStream() {
        try {
            if (null != this._file) {
                return new FileInputStream(this._file);
            }
            ZipFile zf = new ZipFile(this._zipFile);
            ZipEntry entry = zf.getEntry(this._entryName);
            return zf.getInputStream(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeProps(Properties toRemoveFrom) {
        Properties toRemove = this.getProperties();
        for (Object key : toRemove.keySet()) {
            toRemoveFrom.remove(key);
        }
    }

    public void copyTo(File toCopyTo) {
        try {
            InputStream is = this.getInputStream();
            FileOutputStream fos = new FileOutputStream(toCopyTo);
            int buf = is.read();
            while (-1 != buf) {
                fos.write(buf);
                buf = is.read();
            }
            fos.flush();
            fos.close();
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalizedFileName(Locale loc) {
        String name = new File(this.getPath()).getPath().substring(this.getPath().lastIndexOf(File.separator) + 1);
        return new File(name.substring(0, name.lastIndexOf(".properties")) + "_" + loc + ".properties").getName();
    }

    public String getUnlocalizedPath(Locale loc) {
        String path = this.getPath().substring(0, new File(this.getPath()).getPath().lastIndexOf(File.separator));
        String name = this.getPath().substring(new File(this.getPath()).getPath().lastIndexOf(File.separator));
        return path + name.replaceAll("_" + loc.toString(), "");
    }

    public static Locale parseLocaleFromPropsFileName(String propsFileName) {
        if (!propsFileName.endsWith(".properties")) {
            return null;
        }
        String buf = propsFileName.substring(0, propsFileName.length() - ".properties".length());
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length; ++i) {
            if (!buf.endsWith("_" + availableLocales[i].toString())) continue;
            return availableLocales[i];
        }
        return null;
    }

    public Properties getTranslateableProperties() {
        String name = null == this._entryName ? this._file.getName() : (-1 == this._entryName.lastIndexOf(File.separator) ? this._entryName : this._entryName.substring(this._entryName.lastIndexOf(File.separator)));
        if (name.startsWith("I18nStrings")) {
            return this.getProperties();
        }
        Properties ret = this.getProperties();
        Enumeration<Object> e = ret.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.endsWith(".image") || key.endsWith(".rolloverimage") || key.endsWith(".disabledimage") || key.endsWith(".frameIcon") || key.endsWith(".file") || key.endsWith(".images") || key.endsWith(".accelerator") || key.equals("path.defaults")) {
                ret.remove(key);
            }
            if (!key.endsWith(".noi18n") || !ret.getProperty(key).equalsIgnoreCase("true")) continue;
            ret.remove(key);
            ret.remove(key.substring(0, key.length() - ".noi18n".length()));
        }
        return ret;
    }
}

