/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.rtffix;

import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.nio.charset.StandardCharsets;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.rtffix.SquirrelStyledTextTransferable;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RtfGenerator;
import org.fife.ui.rsyntaxtextarea.Token;

public class RtfFix {
    public static void copyAsStyledText(SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        int selEnd;
        int selStart = squirrelRSyntaxTextArea.getSelectionStart();
        if (selStart != (selEnd = squirrelRSyntaxTextArea.getSelectionEnd())) {
            String html = HtmlUtil.getTextAsHtml((RSyntaxTextArea)squirrelRSyntaxTextArea, (int)selStart, (int)selEnd);
            byte[] rtfBytes = RtfFix.getTextAsRtf(selStart, selEnd, squirrelRSyntaxTextArea);
            SquirrelStyledTextTransferable contents = new SquirrelStyledTextTransferable(html, rtfBytes);
            Clipboard cb = squirrelRSyntaxTextArea.getToolkit().getSystemClipboard();
            try {
                cb.setContents(contents, null);
            }
            catch (IllegalStateException var8) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
        }
    }

    private static byte[] getTextAsRtf(int start, int end, SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        Token tokenList;
        RtfGenerator gen = new RtfGenerator(squirrelRSyntaxTextArea.getBackground());
        for (Token t = tokenList = squirrelRSyntaxTextArea.getTokenListFor(start, end); t != null; t = t.getNextToken()) {
            if (!t.isPaintable()) continue;
            if (t.length() == 1 && t.charAt(0) == '\n') {
                gen.appendNewline();
                continue;
            }
            Font font = squirrelRSyntaxTextArea.getFontForTokenType(t.getType());
            Color bg = squirrelRSyntaxTextArea.getBackgroundForToken(t);
            boolean underline = squirrelRSyntaxTextArea.getUnderlineForToken(t);
            if (t.isWhitespace()) {
                gen.appendToDocNoFG(t.getLexeme(), font, bg, underline);
                continue;
            }
            Color fg = squirrelRSyntaxTextArea.getForegroundForToken(t);
            gen.appendToDoc(t.getLexeme(), font, fg, bg, underline);
        }
        return gen.getRtf().getBytes(StandardCharsets.UTF_8);
    }
}

