/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NapkinSliderUI
extends BasicSliderUI
implements NapkinPainter {
    private Icon thumb;
    private DrawnLineHolder track;
    private final Rectangle trackBounds;
    private final boolean vertical;
    private final List<DrawnLineHolder> major;
    private int majorPos;
    private final List<DrawnLineHolder> minor;
    private int minorPos;
    private final Rectangle tickBounds;
    private int textHeight;

    public static ComponentUI createUI(JComponent c) {
        return new NapkinSliderUI((JSlider)c);
    }

    private NapkinSliderUI(JSlider c) {
        super(c);
        this.vertical = c.getOrientation() == 1;
        this.trackBounds = new Rectangle();
        this.tickBounds = new Rectangle();
        this.major = new ArrayList<DrawnLineHolder>(0);
        this.minor = new ArrayList<DrawnLineHolder>(0);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.minorPos = 0;
        this.majorPos = 0;
        super.paint(g, c);
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.thumb == null) {
            int dir = 5;
            if (this.vertical) {
                dir = NapkinUtil.isLeftToRight(this.slider) ? 3 : 7;
            }
            this.thumb = NapkinIconFactory.createArrowIcon(dir);
        }
        return new Dimension(this.thumb.getIconWidth(), this.thumb.getIconHeight());
    }

    @Override
    public void setThumbLocation(int x, int y) {
        Rectangle unionRect = new Rectangle(this.thumbRect);
        this.thumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(unionRect.x - 3, unionRect.y - 3, unionRect.width + 6, unionRect.height + 6);
    }

    @Override
    public void paintThumb(Graphics g) {
        this.thumb.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
    }

    @Override
    public void paintTrack(Graphics g) {
        this.trackBounds.width = this.trackRect.width;
        this.trackBounds.height = this.trackRect.height;
        this.trackBounds.x = this.trackRect.x;
        this.trackBounds.y = this.trackRect.y;
        g.setColor(this.slider.getForeground());
        this.track = NapkinUtil.paintLine(g, this.vertical, this.track, this.trackBounds);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tick, int x) {
        this.paintTick(this.minor, this.minorPos++, g, x, 0, x, tick.height / 2 - 1);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tick, int x) {
        this.paintTick(this.major, this.majorPos++, g, x, 0, x, tick.height - 2);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tick, int y) {
        this.paintTick(this.minor, this.minorPos++, g, 0, y, tick.width / 2 - 1, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tick, int y) {
        this.paintTick(this.major, this.majorPos++, g, 0, y, tick.width - 2, y);
    }

    private void paintTick(List<DrawnLineHolder> ticks, int pos, Graphics g, int x, int y, int width, int height) {
        boolean vertTicks = !this.vertical;
        this.tickBounds.x = x;
        this.tickBounds.y = y;
        this.tickBounds.width = width;
        this.tickBounds.height = height;
        if (vertTicks) {
            this.tickBounds.x /= 4;
        } else {
            this.tickBounds.y /= 4;
        }
        while (pos >= ticks.size()) {
            ticks.add(null);
        }
        DrawnLineHolder holder = ticks.get(pos);
        g.setColor(this.slider.getForeground());
        holder = NapkinUtil.paintLine(g, vertTicks, holder, this.tickBounds);
        ticks.set(pos, holder);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    @Override
    public void superPaint(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        int labelCenter = this.xPositionForValue(value);
        int labelLeft = labelCenter - label.getPreferredSize().width / 2;
        g.drawString(((JLabel)label).getText(), labelLeft, this.textHeight);
    }

    @Override
    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        int labelCenter = this.yPositionForValue(value);
        int labelTop = labelCenter - label.getPreferredSize().height / 2;
        g.drawString(((JLabel)label).getText(), 0, labelTop + this.textHeight);
    }

    @Override
    public void paintLabels(Graphics g) {
        Font oldFont = g.getFont();
        Font font = NapkinUtil.currentTheme(this.slider).getTextFont();
        g.setFont(font);
        this.textHeight = (int)(0.5f * font.getLineMetrics("0123456789", ((Graphics2D)g).getFontRenderContext()).getHeight() + 0.5f);
        super.paintLabels(g);
        g.setFont(oldFont);
    }
}

