/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.constraint;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.AbstractConstraintSource;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.CKConstraintSource;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintInfo;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.FKConstraintSource;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.PKConstraintSource;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.UQConstraintSource;

public class ConstraintSourceBuilder {
    AbstractConstraintSource constraintSource;
    ISession session;

    public ConstraintSourceBuilder(ISession session) {
        this.session = session;
    }

    public String getConstraintSource() {
        if (this.constraintSource != null) {
            return this.constraintSource.getSource();
        }
        return null;
    }

    public void buildConstraintSource(ConstraintInfo ci) throws Exception {
        if (ci.getConstraintType() == ConstraintInfo.ConstraintType.P) {
            this.constraintSource = new PKConstraintSource(this.session, ci);
        } else if (ci.getConstraintType() == ConstraintInfo.ConstraintType.C) {
            this.constraintSource = new CKConstraintSource(this.session, ci);
        } else if (ci.getConstraintType() == ConstraintInfo.ConstraintType.R) {
            this.constraintSource = new FKConstraintSource(this.session, ci);
        } else if (ci.getConstraintType() == ConstraintInfo.ConstraintType.U) {
            this.constraintSource = new UQConstraintSource(this.session, ci);
        }
        this.constraintSource.readConstraintColumnNames();
        this.constraintSource.buildDropStatement();
        this.constraintSource.buildAddStatement();
        this.constraintSource.buildConstraintClause();
    }
}

