/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.constraint;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintColumnInfo;
import net.sourceforge.squirrel_sql.plugins.oracle.constraint.ConstraintInfo;

public abstract class AbstractConstraintSource {
    String dropStmt;
    String addStmt;
    String constraintClause;
    List<ConstraintColumnInfo> columns;
    ConstraintInfo ci;
    ISession session;
    private final String SQL_COLUMNS = "select  owner, constraint_name, table_name, column_name, position from all_cons_columns  where owner = ? and constraint_name = ?  order by position";

    public AbstractConstraintSource(ISession session, ConstraintInfo ci) {
        if (session == null) {
            throw new IllegalStateException("Null ISession");
        }
        if (ci == null) {
            throw new IllegalStateException("Null ConstraintInfo");
        }
        this.session = session;
        this.ci = ci;
    }

    public void buildDropStatement() {
        this.dropStmt = "ALTER TABLE " + this.ci.getOwner() + "." + this.ci.getTableName() + "\n  DROP CONSTRAINT " + this.ci.getConstraintName();
    }

    public void buildAddStatement() {
        this.addStmt = "ALTER TABLE " + this.ci.getOwner() + "." + this.ci.getTableName() + " ADD";
    }

    protected String columnNamesAsCSV(List<ConstraintColumnInfo> cols) {
        StringBuffer ret = new StringBuffer();
        boolean first = true;
        for (ConstraintColumnInfo column : cols) {
            if (!first) {
                ret.append(", ");
            } else {
                first = false;
            }
            ret.append(column.getColumnName());
        }
        return ret.toString();
    }

    public void readConstraintColumnNames() throws SQLException {
        this.columns = this.readConstraintColumns(this.ci.getOwner(), this.ci.getConstraintName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ConstraintColumnInfo> readConstraintColumns(String schema, String constraintName) throws SQLException {
        ArrayList<ConstraintColumnInfo> columns = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.session.getSQLConnection().prepareStatement("select  owner, constraint_name, table_name, column_name, position from all_cons_columns  where owner = ? and constraint_name = ?  order by position");
            pstmt.setString(1, schema);
            pstmt.setString(2, constraintName);
            columns = new ArrayList<ConstraintColumnInfo>();
            rs = pstmt.executeQuery();
            while (rs.next()) {
                columns.add(new ConstraintColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(5)));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs, (boolean)true);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return columns;
    }

    public abstract void buildConstraintClause() throws Exception;

    public String getSource() {
        return this.dropStmt + ";\n\n" + this.addStmt + " (\n" + this.constraintClause + ");";
    }
}

