/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISyntaxHighlightTokenMatcher;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HQLCompletionInfoCollection;

public class HqlSyntaxHighlightTokenMatcher
implements ISyntaxHighlightTokenMatcher {
    private HQLCompletionInfoCollection _hqlCompletionInfoCollection;
    private ArrayList<SQLTokenListener> _listeners = new ArrayList();

    public HqlSyntaxHighlightTokenMatcher(HQLCompletionInfoCollection hqlCompletionInfoCollection) {
        this._hqlCompletionInfoCollection = hqlCompletionInfoCollection;
    }

    public boolean isError(int offset, int len) {
        return false;
    }

    public boolean isTable(char[] buffer, int offset, int len) {
        String classNameCandidate = this.getString(buffer, offset, len);
        boolean ret = this._hqlCompletionInfoCollection.isMappeadClass(classNameCandidate);
        if (ret) {
            this.fireClassFound(classNameCandidate);
        }
        return ret;
    }

    public boolean isFunction(char[] buffer, int offset, int len) {
        return this._hqlCompletionInfoCollection.isFunction(this.getString(buffer, offset, len));
    }

    public boolean isDataType(char[] buffer, int offset, int len) {
        return false;
    }

    public boolean isStatementSeparator(char[] buffer, int offset, int len) {
        return false;
    }

    public boolean isColumn(char[] buffer, int offset, int len) {
        return this._hqlCompletionInfoCollection.isMappedAttribute(this.getString(buffer, offset, len));
    }

    public boolean isKeyword(char[] buffer, int offset, int len) {
        return this._hqlCompletionInfoCollection.isKeyword(this.getString(buffer, offset, len));
    }

    public void addSQLTokenListener(SQLTokenListener tl) {
        this._listeners.add(tl);
    }

    public void removeSQLTokenListener(SQLTokenListener tl) {
        this._listeners.remove(tl);
    }

    private String getString(char[] buffer, int offset, int len) {
        return new String(buffer, offset, len);
    }

    private void fireClassFound(String className) {
        for (SQLTokenListener listener : this._listeners) {
            listener.tableOrViewFound(className);
        }
    }
}

