/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;

public class AliasInfo
extends CompletionInfo {
    private MappedClassInfo _mci;
    private String _alias;
    private String _toString;

    public AliasInfo(MappedClassInfo mci, String alias) {
        this._mci = mci;
        this._alias = alias;
        this._toString = alias + " (alias for " + this._mci.getSimpleClassName() + ")";
    }

    public boolean matches(CompletionParser parser) {
        return this._alias.startsWith(parser.getStringToReplace());
    }

    public String getCompareString() {
        return this._alias;
    }

    public ArrayList<PropertyInfo> getQualifiedMatchingAttributes(CompletionParser parser) {
        if (1 < parser.size() && parser.getToken(0).equals(this._alias)) {
            return this._mci.getQualifiedMatchingAttributes(new CompletionParser(this._mci.getClassName() + "." + parser.getAllButFirst()));
        }
        return new ArrayList<PropertyInfo>();
    }

    public String toString() {
        return this._toString;
    }

    public PropertyInfo getAttributeByName(String attrName) {
        return this._mci.getAttributeByName(attrName);
    }
}

