/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.smarttools.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.smarttools.STDataType;
import net.sourceforge.squirrel_sql.plugins.smarttools.SmarttoolsHelper;
import net.sourceforge.squirrel_sql.plugins.smarttools.comp.STButton;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.ISmarttoolFrame;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.SmarttoolFindBadNullValuesFrame;

public class SmarttoolChangeValuesFrame
extends DialogWidget
implements ISmarttoolFrame,
ActionListener {
    private static final long serialVersionUID = 3680564541641320485L;
    private final String WILDCARD = "%";
    private final String INDENT = "   ";
    private final int START_SEARCHING = 0;
    private final int START_CHANGEING = 1;
    private final int STOP_WORKING = 2;
    private static final ILogger log = LoggerController.createLogger(SmarttoolFindBadNullValuesFrame.class);
    private static final StringManager stringManager = StringManagerFactory.getStringManager(SmarttoolFindBadNullValuesFrame.class);
    private final int TABLE_COL_MARKER = 0;
    private final int TABLE_COL_TABLE = 1;
    private final int TABLE_COL_COLUMNNAME = 2;
    private final int TABLE_COL_RECORDS = 4;
    private final int TABLE_COL_STATUS = 5;
    private final int[] TABLE_DEFAULT_COL_WIDTH = new int[]{30, 205, 210, 80, 120, 50};
    private ISession session;
    private Thread threadSearching = null;
    private Thread threadChanging = null;
    private boolean threadSuspended;
    private Vector<String> vecHeader = new Vector();
    private Vector<Vector<Object>> vecData = new Vector();
    private boolean operatorActionListenerDisabled = false;
    private JPanel panelMain = new JPanel();
    private JLabel lblColumn = new JLabel();
    private JTextField tfColumnName = new JTextField();
    private JLabel lblDatatype = new JLabel();
    private JComboBox cbDataType = new JComboBox();
    private JCheckBox chkDisplayOnlyTablesWithData = new JCheckBox();
    private JLabel lblWhere = new JLabel();
    private JLabel lblOperator = new JLabel();
    private JComboBox cbOperator = new JComboBox();
    private JTextField tfOldValue = new JTextField();
    private JLabel lblNewValue = new JLabel();
    private JTextField tfNewValue = new JTextField();
    private JCheckBox chkEnableChangeData = new JCheckBox();
    private STButton btnSearchData = new STButton();
    private STButton btnChangeData = new STButton();
    private STButton btnStop = new STButton();
    private JPanel panelResult = new JPanel();
    private STButton btnSelectAll = new STButton();
    private STButton btnSelectNone = new STButton();
    private JLabel lblTitleResult = new JLabel();
    private JTable tblResult = new JTable();
    private STButton btnPrint = new STButton();
    private JLabel lblFooterTableResult = new JLabel();
    private JProgressBar pbMain = new JProgressBar();
    private ImageIcon iconMarked = SmarttoolsHelper.loadIcon("gridMarked16x16.png");
    private ImageIcon iconDemarked = SmarttoolsHelper.loadIcon("gridDemarked16x16.png");

    public SmarttoolChangeValuesFrame(ISession session, String title) {
        super("Smarttool - " + title, true, true, true, true, session.getApplication());
        this.session = session;
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.moveToFront();
        JOptionPane.showMessageDialog((Component)session.getApplication().getMainFrame(), i18n.WARNING, i18n.WARNING_TITLE, 2);
    }

    private void initLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.createTableHeader();
        this.tblResult = new JTable(this.vecData, this.vecHeader);
        this.getContentPane().add(this.createPanelMain());
        this.initVisualObjects();
    }

    private void initVisualObjects() {
        this.lblColumn.setText(i18n.GLOBAL_COLUMN);
        this.lblDatatype.setText(i18n.GLOBAL_DATATYPE);
        this.lblNewValue.setText(i18n.LBL_NEW_VALUE);
        this.lblTitleResult.setText(i18n.LBL_TITLE_RESULT);
        this.lblOperator.setText(i18n.GLOBAL_OPERATOR);
        this.lblNewValue.setText(i18n.LBL_NEW_VALUE);
        this.lblWhere.setText(i18n.LBL_WHERE);
        this.tfColumnName.setToolTipText(i18n.TOOLTIP_WILDCARD);
        this.tfOldValue.setToolTipText(i18n.TOOLTIP_TF_OLD_VALUE);
        this.btnSearchData.setText(i18n.LBL_BTN_SEARCHDATA);
        this.btnSearchData.setIcon(SmarttoolsHelper.loadIcon("start16x16.png"));
        this.btnSearchData.addActionListener(this);
        this.btnChangeData.setText(i18n.LBL_BTN_CHANGEDATA);
        this.btnChangeData.setIcon(SmarttoolsHelper.loadIcon("change16x16.png"));
        this.btnChangeData.addActionListener(this);
        this.btnStop.setText(i18n.GLOBAL_BTN_STOP);
        this.btnStop.setIcon(SmarttoolsHelper.loadIcon("stop16x16.png"));
        this.btnStop.addActionListener(this);
        this.btnStop.setEnabled(false);
        this.btnPrint.setText(i18n.GLOBAL_BTN_PRINT);
        this.btnPrint.setIcon(SmarttoolsHelper.loadIcon("printer16x16.png"));
        this.btnPrint.addActionListener(this);
        this.btnPrint.setEnabled(false);
        this.btnSelectAll.setText(i18n.LBL_BTN_ALL);
        this.btnSelectAll.setToolTipText(i18n.TOOLTIP_BTN_ALL);
        this.btnSelectAll.setIcon(this.iconMarked);
        this.btnSelectAll.addActionListener(this);
        this.btnSelectNone.setText(i18n.LBL_BTN_NONE);
        this.btnSelectNone.setToolTipText(i18n.TOOLTIP_BTN_NONE);
        this.btnSelectNone.setIcon(this.iconDemarked);
        this.btnSelectNone.addActionListener(this);
        this.fillDataTypes();
        this.cbDataType.addActionListener(this);
        this.cbDataType.setSelectedIndex(0);
        this.cbOperator.addActionListener(this);
        this.chkDisplayOnlyTablesWithData.setText(i18n.LBL_CHK_ONLY_TABLES_WITH_DATA);
        this.chkEnableChangeData.setText(i18n.LBL_CHK_ENABLE_CHANGE_DATA);
        this.chkEnableChangeData.addActionListener(this);
        this.tblResult.setDefaultRenderer(Object.class, new SmarttoolChangeValuesTableCellRenderer());
        this.tblResult.setModel(new SmarttoolChangeValuesTableModel());
        this.tblResult.setRowSelectionAllowed(true);
        this.tblResult.setColumnSelectionAllowed(false);
        this.tblResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (SmarttoolChangeValuesFrame.this.tblResult.getSelectedColumn() == 0) {
                    int row = SmarttoolChangeValuesFrame.this.tblResult.getSelectedRow();
                    boolean newMarkerValue = (Boolean)SmarttoolChangeValuesFrame.this.tblResult.getValueAt(row, 0) == false;
                    SmarttoolChangeValuesFrame.this.tblResult.setValueAt(newMarkerValue, row, 0);
                    SmarttoolChangeValuesFrame.this.tblResult.setValueAt(newMarkerValue ? 0 : -1, row, 5);
                }
            }
        });
        this.tblResult.setAutoResizeMode(0);
        SmarttoolsHelper.setColumnWidth(this.tblResult, this.TABLE_DEFAULT_COL_WIDTH);
        this.pbMain.setValue(0);
        this.pbMain.setStringPainted(true);
        this.controlComponents(2);
    }

    private void createTableHeader() {
        this.vecHeader.add("");
        this.vecHeader.add(i18n.GLOBAL_TABLE);
        this.vecHeader.add(i18n.GLOBAL_COLUMN);
        this.vecHeader.add(i18n.GLOBAL_DATATYPE);
        this.vecHeader.add(i18n.GLOBAL_RECORDS);
        this.vecHeader.add(i18n.GLOBAL_STATUS);
    }

    private void fillDataTypes() {
        this.cbDataType.removeAllItems();
        List<STDataType> data = SmarttoolsHelper.getListSmarttoolsDataType(false);
        for (int i = 0; i < data.size(); ++i) {
            this.cbDataType.addItem(data.get(i));
        }
        this.cbDataType.setSelectedIndex(0);
    }

    public JPanel createPanelMain() {
        this.panelMain.setName("panelMain");
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:100DLU:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:80DLU:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:8DLU:GROW(1.0),FILL:DEFAULT:NONE,FILL:4DLU:NONE", "CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:4DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        this.panelMain.setLayout((LayoutManager)formlayout1);
        this.lblColumn.setName("lblColumn");
        this.lblColumn.setText("column name");
        this.panelMain.add((Component)this.lblColumn, cc.xy(2, 2));
        this.tfColumnName.setName("tfColumnName");
        this.panelMain.add((Component)this.tfColumnName, cc.xy(4, 2));
        this.lblDatatype.setName("lblDatatype");
        this.lblDatatype.setText("datatype");
        this.panelMain.add((Component)this.lblDatatype, cc.xy(6, 2));
        this.cbDataType.setName("cbDataType");
        this.panelMain.add((Component)this.cbDataType, cc.xy(8, 2));
        this.btnSearchData.setActionCommand("JButton");
        this.btnSearchData.setName("btnSearchData");
        this.btnSearchData.setText("search data");
        this.panelMain.add((Component)this.btnSearchData, cc.xy(13, 2));
        this.btnChangeData.setActionCommand("JButton");
        this.btnChangeData.setEnabled(false);
        this.btnChangeData.setName("btnChangeData");
        this.btnChangeData.setText("change data");
        this.panelMain.add((Component)this.btnChangeData, cc.xy(13, 4));
        this.chkDisplayOnlyTablesWithData.setActionCommand("display only rows with data");
        this.chkDisplayOnlyTablesWithData.setName("chkDisplayOnlyTablesWithData");
        this.chkDisplayOnlyTablesWithData.setSelected(true);
        this.chkDisplayOnlyTablesWithData.setText("display only rows with data");
        this.panelMain.add((Component)this.chkDisplayOnlyTablesWithData, cc.xy(10, 2));
        this.btnStop.setActionCommand("stop");
        this.btnStop.setEnabled(false);
        this.btnStop.setName("btnStop");
        this.btnStop.setText("stop");
        this.panelMain.add((Component)this.btnStop, cc.xy(13, 6));
        this.pbMain.setName("pbMain");
        this.pbMain.setValue(25);
        this.panelMain.add((Component)this.pbMain, cc.xywh(2, 12, 12, 1));
        this.lblOperator.setName("lblOperator");
        this.lblOperator.setText("operator");
        this.panelMain.add((Component)this.lblOperator, cc.xy(6, 4));
        this.cbOperator.setName("cbOperator");
        this.panelMain.add((Component)this.cbOperator, cc.xy(8, 4));
        this.lblNewValue.setName("lblNewValue");
        this.lblNewValue.setText("new value");
        this.panelMain.add((Component)this.lblNewValue, cc.xy(2, 6));
        this.tfNewValue.setName("tfNewValue");
        this.panelMain.add((Component)this.tfNewValue, cc.xy(4, 6));
        this.chkEnableChangeData.setActionCommand("enable change data");
        this.chkEnableChangeData.setName("chkEnableChangeData");
        this.chkEnableChangeData.setText("enable change button");
        this.panelMain.add((Component)this.chkEnableChangeData, cc.xy(10, 6));
        this.tfOldValue.setName("tfOldValue");
        this.panelMain.add((Component)this.tfOldValue, cc.xy(10, 4));
        this.lblWhere.setName("lblWhere");
        this.lblWhere.setText("where");
        this.lblWhere.setHorizontalAlignment(4);
        this.panelMain.add((Component)this.lblWhere, cc.xy(4, 4));
        this.lblFooterTableResult.setBackground(new Color(153, 153, 153));
        this.lblFooterTableResult.setName("lblFooterTableResult");
        this.lblFooterTableResult.setOpaque(true);
        this.lblFooterTableResult.setText("Finished in ...");
        this.panelMain.add((Component)this.lblFooterTableResult, cc.xywh(2, 10, 12, 1));
        this.panelMain.add((Component)this.createpanelResult(), cc.xywh(2, 8, 12, 1));
        return this.panelMain;
    }

    public JPanel createpanelResult() {
        this.panelResult.setName("panelResult");
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE,FILL:DEFAULT:NONE", "FILL:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        this.panelResult.setLayout((LayoutManager)formlayout1);
        this.btnSelectAll.setActionCommand("all");
        this.btnSelectAll.setName("btnSelectAll");
        this.btnSelectAll.setText("all");
        this.btnSelectAll.setToolTipText("select all result entries");
        this.panelResult.add((Component)this.btnSelectAll, cc.xy(1, 1));
        this.btnSelectNone.setActionCommand("none");
        this.btnSelectNone.setName("btnSelectNone");
        this.btnSelectNone.setText("none");
        this.btnSelectNone.setToolTipText("deselect all result entries");
        this.panelResult.add((Component)this.btnSelectNone, cc.xy(3, 1));
        this.tblResult.setName("tblResult");
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.tblResult);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        this.panelResult.add((Component)jscrollpane1, cc.xywh(1, 3, 7, 1));
        this.lblTitleResult.setBackground(new Color(153, 153, 153));
        this.lblTitleResult.setName("lblTitleResult");
        this.lblTitleResult.setOpaque(true);
        this.lblTitleResult.setText("Found tables and columns:");
        EmptyBorder emptyborder1 = new EmptyBorder(0, 5, 0, 0);
        this.lblTitleResult.setBorder(emptyborder1);
        this.panelResult.add((Component)this.lblTitleResult, cc.xy(5, 1));
        this.btnPrint.setActionCommand("print");
        this.btnPrint.setName("btnPrint");
        this.btnPrint.setText(" print ");
        this.panelResult.add((Component)this.btnPrint, cc.xy(7, 1));
        return this.panelResult;
    }

    @Override
    public void setFocusToFirstEmptyInputField() {
        this.tfColumnName.requestFocusInWindow();
    }

    private String getHeaderText() {
        return this.getTitle();
    }

    private String getFooterText() {
        return i18n.GLOBAL_ALIAS + ": " + this.session.getAlias().getName() + " | " + DateFormat.getDateTimeInstance(2, 3).format(new Date()) + " | " + i18n.GLOBAL_PAGE + " {0}";
    }

    private int getUsedGroup() {
        return ((STDataType)this.cbDataType.getSelectedItem()).getGroup();
    }

    private int getUsedDataType() {
        return ((STDataType)this.cbDataType.getSelectedItem()).getJdbcType();
    }

    private boolean isInputOK(int threadType) {
        if (threadType == 0) {
            if (this.tfColumnName.getText().trim().length() < 1) {
                JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.ERROR_COLUMNNAME_MISSING);
                this.tfColumnName.requestFocusInWindow();
                return false;
            }
        } else {
            int group = this.getUsedGroup();
            if (group == 1) {
                try {
                    Integer.parseInt(this.tfNewValue.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.GLOBAL_ERROR_FORMAT_INTEGER);
                    this.tfNewValue.requestFocusInWindow();
                    return false;
                }
            }
            if (group == 2) {
                try {
                    Double.parseDouble(this.tfNewValue.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.GLOBAL_ERROR_FORMAT_NUMERIC);
                    this.tfNewValue.requestFocusInWindow();
                    return false;
                }
            }
            if (group == 4) {
                int dataType = this.getUsedDataType();
                DateFormat df = null;
                if (dataType == 91) {
                    df = DateFormat.getDateInstance();
                    try {
                        df.parse(this.tfNewValue.getText());
                    }
                    catch (ParseException ex) {
                        JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.GLOBAL_ERROR_FORMAT_DATE);
                        this.tfNewValue.requestFocusInWindow();
                        return false;
                    }
                }
                if (dataType == 93) {
                    df = DateFormat.getDateTimeInstance();
                    try {
                        df.parse(this.tfNewValue.getText());
                    }
                    catch (ParseException ex) {
                        JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.GLOBAL_ERROR_FORMAT_DATETIME);
                        this.tfNewValue.requestFocusInWindow();
                        return false;
                    }
                }
                if (dataType == 92) {
                    df = DateFormat.getTimeInstance();
                    try {
                        df.parse(this.tfNewValue.getText());
                    }
                    catch (ParseException ex) {
                        JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.GLOBAL_ERROR_FORMAT_TIME);
                        this.tfNewValue.requestFocusInWindow();
                        return false;
                    }
                }
            }
            boolean selectedRowExists = false;
            for (int row = 0; row < this.tblResult.getRowCount(); ++row) {
                if (!((Boolean)this.tblResult.getValueAt(row, 0)).booleanValue()) continue;
                selectedRowExists = true;
                break;
            }
            if (!selectedRowExists) {
                JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.ERROR_SELECT_ENTRY);
                return false;
            }
        }
        if (this.tfOldValue.isEnabled() && this.tfOldValue.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.ERROR_MISSING_OLD_VALUE);
            return false;
        }
        return true;
    }

    private String getWhereCondition(String columnName, String value) {
        if (this.cbOperator.getSelectedIndex() > 0) {
            return " where " + columnName + " " + (String)this.cbOperator.getSelectedItem() + " " + value;
        }
        return "";
    }

    private void startSearching() {
        if (this.isInputOK(0)) {
            this.controlComponents(0);
            this.chkEnableChangeData.setSelected(false);
            this.threadSearching = new ThreadSearching();
            this.threadSearching.start();
        }
    }

    private void startChanging() {
        if (this.isInputOK(1) && JOptionPane.showConfirmDialog((Component)this.session.getApplication().getMainFrame(), i18n.QUESTION_START_CHANGING, i18n.QUESTION_START_CHANGING_TITLE, 0) == 0) {
            this.controlComponents(1);
            this.chkEnableChangeData.setSelected(false);
            this.threadChanging = new ThreadChanging();
            this.threadChanging.start();
        }
    }

    private void stopWork() {
        this.threadSuspended = true;
        if (JOptionPane.showConfirmDialog((Component)this.session.getApplication().getMainFrame(), i18n.QUESTION_CANCEL_WORK, i18n.QUESTION_CANCEL_WORK_TITLE, 0) == 0) {
            if (this.threadSearching != null) {
                this.threadSearching = null;
            } else {
                this.threadChanging = null;
            }
            this.controlComponents(2);
        }
        this.threadSuspended = false;
    }

    public void controlComponents(int type) {
        boolean enabled = type == 2;
        this.tfColumnName.setEnabled(enabled);
        this.cbDataType.setEnabled(enabled);
        this.cbOperator.setEnabled(enabled);
        this.controlTfOldValue(enabled);
        this.chkDisplayOnlyTablesWithData.setEnabled(enabled);
        this.chkEnableChangeData.setEnabled(enabled && this.tblResult.getRowCount() > 0);
        this.tfNewValue.setEnabled(enabled && this.chkEnableChangeData.isSelected());
        this.btnSearchData.setEnabled(enabled);
        this.btnChangeData.setEnabled(enabled && this.chkEnableChangeData.isSelected());
        this.btnStop.setEnabled(!enabled);
        this.btnPrint.setEnabled(enabled && this.tblResult.getRowCount() > 0);
        this.btnSelectAll.setEnabled(enabled && this.tblResult.getRowCount() > 0);
        this.btnSelectNone.setEnabled(enabled && this.tblResult.getRowCount() > 0);
        this.tblResult.setEnabled(enabled);
        this.tfColumnName.setBackground(this.tfColumnName.isEnabled() ? Color.WHITE : Color.LIGHT_GRAY);
        this.tfNewValue.setBackground(this.tfNewValue.isEnabled() ? Color.WHITE : Color.LIGHT_GRAY);
    }

    private void controlTfOldValue(boolean enabled) {
        this.tfOldValue.setEnabled(enabled && this.cbOperator.getSelectedIndex() > 0 && !this.isNullOperator());
        if (this.isNullOperator() || this.cbOperator.getSelectedIndex() == 0) {
            this.tfOldValue.setText("");
        }
        this.tfOldValue.setBackground(this.tfOldValue.isEnabled() ? Color.WHITE : Color.LIGHT_GRAY);
    }

    private boolean isNullOperator() {
        return ((String)this.cbOperator.getSelectedItem()).toLowerCase().indexOf("null") > -1;
    }

    private String getOldValue() {
        if (this.isNullOperator()) {
            return "";
        }
        String oldValue = this.tfOldValue.getText();
        if (this.getUsedGroup() == 3 || this.getUsedGroup() == 4) {
            oldValue = "'" + oldValue + "'";
        }
        return oldValue;
    }

    private String getNewValue() {
        String newValue = this.tfNewValue.getText();
        if (this.getUsedGroup() == 3 || this.getUsedGroup() == 4) {
            newValue = "'" + newValue + "'";
        }
        return newValue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnSearchData) {
            this.startSearching();
        } else if (e.getSource() == this.btnChangeData) {
            this.startChanging();
        } else if (e.getSource() == this.btnStop) {
            this.stopWork();
        } else if (e.getSource() == this.btnPrint) {
            SmarttoolsHelper.printTable(this.tblResult, this.getHeaderText(), this.getFooterText());
        } else if (e.getSource() == this.btnSelectAll) {
            SmarttoolsHelper.markAllRows(this.tblResult, 0, true);
            ((SmarttoolChangeValuesTableModel)this.tblResult.getModel()).fireTableDataChanged();
        } else if (e.getSource() == this.btnSelectNone) {
            SmarttoolsHelper.markAllRows(this.tblResult, 0, false);
            ((SmarttoolChangeValuesTableModel)this.tblResult.getModel()).fireTableDataChanged();
        } else if (e.getSource() == this.chkEnableChangeData) {
            this.controlComponents(2);
            this.tfNewValue.requestFocusInWindow();
        } else if (e.getSource() == this.cbDataType) {
            this.operatorActionListenerDisabled = true;
            SmarttoolsHelper.fillOperatorTypes(this.cbOperator, this.getUsedGroup());
            this.cbOperator.insertItemAt(i18n.ENTRY_NO_CONDITION, 0);
            this.operatorActionListenerDisabled = false;
            this.cbOperator.setSelectedIndex(0);
        } else if (e.getSource() == this.cbOperator && !this.operatorActionListenerDisabled) {
            this.controlTfOldValue(true);
        }
    }

    static /* synthetic */ StringManager access$100() {
        return stringManager;
    }

    class SmarttoolChangeValuesTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1355771906563987627L;

        SmarttoolChangeValuesTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class SmarttoolChangeValuesTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -7923233754901241279L;
        private ImageIcon iconMarkedSelected = SmarttoolsHelper.loadIcon("gridMarkedSelected16x16.png");
        private ImageIcon iconDemarkedSelected = SmarttoolsHelper.loadIcon("gridDemarkedSelected16x16.png");
        private ImageIcon iconStatusInit = SmarttoolsHelper.loadIcon("statusInit16x16.png");
        private ImageIcon iconStatusOk = SmarttoolsHelper.loadIcon("statusOk16x16.png");
        private ImageIcon iconStatusError = SmarttoolsHelper.loadIcon("statusError16x16.png");

        SmarttoolChangeValuesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel lbl = new JLabel();
            lbl.setOpaque(true);
            if (column == 0 && value instanceof Boolean) {
                lbl.setHorizontalAlignment(0);
                if (((Boolean)value).booleanValue()) {
                    if (isSelected) {
                        lbl.setIcon(this.iconMarkedSelected);
                    } else {
                        lbl.setIcon(SmarttoolChangeValuesFrame.this.iconMarked);
                    }
                } else if (isSelected) {
                    lbl.setIcon(this.iconDemarkedSelected);
                } else {
                    lbl.setIcon(SmarttoolChangeValuesFrame.this.iconDemarked);
                }
            } else if (column == 5 && value instanceof Integer) {
                if (((Boolean)SmarttoolChangeValuesFrame.this.tblResult.getValueAt(row, 0)).booleanValue()) {
                    int status = (Integer)value;
                    lbl.setHorizontalAlignment(0);
                    if (status == 0) {
                        lbl.setIcon(this.iconStatusInit);
                    } else if (status == 1) {
                        lbl.setIcon(this.iconStatusOk);
                    } else if (status == 2) {
                        lbl.setIcon(this.iconStatusError);
                    }
                }
            } else if (value instanceof String) {
                lbl.setText((String)value);
            }
            if (column == 4) {
                lbl.setHorizontalAlignment(0);
            }
            if (isSelected) {
                lbl.setBackground(new Color(0, 0, 100));
                lbl.setForeground(Color.LIGHT_GRAY);
            }
            return lbl;
        }
    }

    class ThreadChanging
    extends Thread {
        private Thread thisThread = null;

        ThreadChanging() {
        }

        @Override
        public void run() {
            super.run();
            this.thisThread = Thread.currentThread();
            this.startChanging();
            SmarttoolChangeValuesFrame.this.controlComponents(2);
            SmarttoolChangeValuesFrame.this.threadChanging = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isThreadInvalid() {
            if (this.thisThread != SmarttoolChangeValuesFrame.this.threadChanging) {
                return true;
            }
            try {
                ThreadChanging threadChanging = this;
                synchronized (threadChanging) {
                    while (SmarttoolChangeValuesFrame.this.threadSuspended) {
                        this.wait(200L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        private void startChanging() {
            long startTime = System.currentTimeMillis();
            String oldValue = SmarttoolChangeValuesFrame.this.getOldValue();
            String newValue = SmarttoolChangeValuesFrame.this.getNewValue();
            SmarttoolChangeValuesFrame.this.pbMain.setValue(0);
            SmarttoolChangeValuesFrame.this.pbMain.setMaximum(0);
            for (int r = 0; r < SmarttoolChangeValuesFrame.this.tblResult.getRowCount(); ++r) {
                if (!((Boolean)SmarttoolChangeValuesFrame.this.tblResult.getValueAt(r, 0)).booleanValue()) continue;
                SmarttoolChangeValuesFrame.this.pbMain.setMaximum(SmarttoolChangeValuesFrame.this.pbMain.getMaximum() + 1);
            }
            Statement stmt = null;
            boolean error = false;
            try {
                stmt = SmarttoolChangeValuesFrame.this.session.getSQLConnection().createStatement();
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(null, i18n.ERROR_CREATING_STATEMENT);
                log.error((Object)e);
            }
            int i = 0;
            for (int row = 0; row < SmarttoolChangeValuesFrame.this.tblResult.getRowCount(); ++row) {
                if (!((Boolean)SmarttoolChangeValuesFrame.this.tblResult.getValueAt(row, 0)).booleanValue()) continue;
                String tableName = (String)SmarttoolChangeValuesFrame.this.tblResult.getValueAt(row, 1);
                String columnName = (String)SmarttoolChangeValuesFrame.this.tblResult.getValueAt(row, 2);
                SmarttoolChangeValuesFrame.this.pbMain.setString(tableName + "." + columnName + " " + ++i + "/" + SmarttoolChangeValuesFrame.this.pbMain.getMaximum());
                try {
                    String sql = "UPDATE " + tableName + " SET " + columnName + " = " + newValue + " " + SmarttoolChangeValuesFrame.this.getWhereCondition(columnName, oldValue);
                    int rowsAffected = stmt.executeUpdate(sql);
                    int rowCount = SmarttoolsHelper.getRowCount(stmt, tableName);
                    SmarttoolChangeValuesFrame.this.tblResult.setValueAt(new Integer(1), row, 5);
                    SmarttoolChangeValuesFrame.this.tblResult.setValueAt(rowsAffected + "/" + rowCount, row, 4);
                }
                catch (SQLException e) {
                    error = true;
                    SmarttoolChangeValuesFrame.this.tblResult.setValueAt(new Integer(2), row, 5);
                    log.error((Object)e);
                }
                SmarttoolChangeValuesFrame.this.pbMain.setValue(i);
                SmarttoolChangeValuesFrame.this.pbMain.repaint();
                if (this.isThreadInvalid()) break;
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(null, i18n.ERROR_CLOSING_STATEMENT);
                log.error((Object)e);
            }
            long diffTime = System.currentTimeMillis() - startTime;
            SmarttoolChangeValuesFrame.this.lblFooterTableResult.setText(" " + i18n.INFO_CHANGING_FINISHED + " " + diffTime + " ms");
            if (error) {
                JOptionPane.showMessageDialog(null, i18n.ERROR_CHANGING_DATA);
            }
        }
    }

    class ThreadSearching
    extends Thread {
        private Thread thisThread = null;

        ThreadSearching() {
        }

        @Override
        public void run() {
            super.run();
            this.thisThread = Thread.currentThread();
            this.startSearching();
            SmarttoolChangeValuesFrame.this.controlComponents(2);
            SmarttoolChangeValuesFrame.this.threadSearching = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isThreadInvalid() {
            if (this.thisThread != SmarttoolChangeValuesFrame.this.threadSearching) {
                return true;
            }
            try {
                ThreadSearching threadSearching = this;
                synchronized (threadSearching) {
                    while (SmarttoolChangeValuesFrame.this.threadSuspended) {
                        this.wait(200L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        private void startSearching() {
            long startTime = System.currentTimeMillis();
            ((DefaultTableModel)SmarttoolChangeValuesFrame.this.tblResult.getModel()).setDataVector(new Vector(), SmarttoolChangeValuesFrame.this.vecHeader);
            String tableNamePattern = "%";
            String oldValue = SmarttoolChangeValuesFrame.this.getOldValue();
            try {
                ITableInfo[] tableInfoArray = SmarttoolChangeValuesFrame.this.session.getMetaData().getTables(null, null, tableNamePattern, new String[]{"TABLE"}, null);
                SmarttoolChangeValuesFrame.this.pbMain.setValue(0);
                SmarttoolChangeValuesFrame.this.pbMain.setMaximum(tableInfoArray.length);
                for (int i = 0; i < tableInfoArray.length; ++i) {
                    ITableInfo tableInfo = tableInfoArray[i];
                    SmarttoolChangeValuesFrame.this.pbMain.setString(tableInfo.getSimpleName() + " " + (i + 1) + "/" + SmarttoolChangeValuesFrame.this.pbMain.getMaximum());
                    this.checkColumns(tableInfo, oldValue);
                    SmarttoolChangeValuesFrame.this.pbMain.setValue(i + 1);
                    SmarttoolChangeValuesFrame.this.pbMain.repaint();
                    if (this.isThreadInvalid()) break;
                }
                long diffTime = System.currentTimeMillis() - startTime;
                SmarttoolChangeValuesFrame.this.lblFooterTableResult.setText(" " + i18n.INFO_SEARCHING_FINISHED + " " + diffTime + " ms");
            }
            catch (SQLException e) {
                log.error((Object)e);
                JOptionPane.showMessageDialog(null, i18n.ERROR_SEARCHING_DATA);
            }
        }

        private void checkColumns(ITableInfo tableInfo, String oldValue) throws SQLException {
            TableColumnInfo[] columnInfos = SmarttoolChangeValuesFrame.this.session.getMetaData().getColumnInfo(tableInfo);
            Statement stmt = SmarttoolChangeValuesFrame.this.session.getSQLConnection().createStatement();
            int resultFound = 0;
            for (int c = 0; c < columnInfos.length; ++c) {
                TableColumnInfo tableColumnInfo = columnInfos[c];
                String sql = null;
                if (this.isStringValueCheck(tableColumnInfo) || this.isIntegerValueCheck(tableColumnInfo) || this.isNumericValueCheck(tableColumnInfo) || this.isDateValueCheck(tableColumnInfo)) {
                    sql = "SELECT COUNT(*) FROM " + tableInfo.getSimpleName() + " " + SmarttoolChangeValuesFrame.this.getWhereCondition(tableColumnInfo.getColumnName(), oldValue);
                }
                if (sql == null) continue;
                try {
                    resultFound = SmarttoolsHelper.checkColumnData(stmt, sql);
                    if (resultFound <= 0 && SmarttoolChangeValuesFrame.this.chkDisplayOnlyTablesWithData.isSelected()) continue;
                    this.addTableEntry(stmt, tableInfo.getSimpleName(), tableColumnInfo.getColumnName(), SmarttoolsHelper.getDataTypeForDisplay(tableColumnInfo), resultFound);
                    continue;
                }
                catch (SQLException e) {
                    String text = "   " + i18n.ERROR_ON_TABLE + " [" + tableInfo.getSimpleName() + "] " + i18n.GLOBAL_COLUMN + " [" + tableColumnInfo.getColumnName() + "] :" + e.getLocalizedMessage();
                    this.addTableEntry(stmt, tableInfo.getSimpleName(), tableColumnInfo.getColumnName(), SmarttoolsHelper.getDataTypeForDisplay(tableColumnInfo), -1);
                    log.error((Object)text);
                }
            }
            stmt.close();
        }

        private void addTableEntry(Statement stmt, String tableName, String columnName, String dataType, int recordsFound) throws SQLException {
            if (!SmarttoolChangeValuesFrame.this.chkDisplayOnlyTablesWithData.isSelected() || recordsFound > 0) {
                Vector<Object> vecRow = new Vector<Object>();
                vecRow.add(Boolean.FALSE);
                vecRow.add(tableName);
                vecRow.add(columnName);
                vecRow.add(dataType);
                if (recordsFound > -1) {
                    String records = recordsFound + "/" + SmarttoolsHelper.getRowCount(stmt, tableName);
                    vecRow.add(records);
                } else {
                    vecRow.add(i18n.ERROR_ON_TABLE);
                }
                vecRow.add(new Integer(0));
                DefaultTableModel tm = (DefaultTableModel)SmarttoolChangeValuesFrame.this.tblResult.getModel();
                tm.addRow(vecRow);
                tm.fireTableDataChanged();
                SmarttoolsHelper.setColumnWidth(SmarttoolChangeValuesFrame.this.tblResult, SmarttoolChangeValuesFrame.this.TABLE_DEFAULT_COL_WIDTH);
            }
        }

        private boolean isValidColumnName(String columnName) {
            String columnNameInput = SmarttoolChangeValuesFrame.this.tfColumnName.getText();
            if (columnNameInput.endsWith("%")) {
                String cni = columnNameInput.replaceAll("\\%", "").toLowerCase();
                return columnName.toLowerCase().startsWith(cni);
            }
            return columnName.equalsIgnoreCase(columnNameInput);
        }

        private boolean isStringValueCheck(TableColumnInfo tableColumnInfo) {
            int dataType = SmarttoolChangeValuesFrame.this.getUsedDataType();
            return SmarttoolChangeValuesFrame.this.getUsedGroup() == 3 && (dataType == tableColumnInfo.getDataType() || dataType == -1 && SmarttoolsHelper.isDataTypeString(tableColumnInfo.getDataType())) && this.isValidColumnName(tableColumnInfo.getColumnName());
        }

        private boolean isIntegerValueCheck(TableColumnInfo tableColumnInfo) {
            int dataType = SmarttoolChangeValuesFrame.this.getUsedDataType();
            return SmarttoolChangeValuesFrame.this.getUsedGroup() == 1 && (dataType == tableColumnInfo.getDataType() || dataType == -1 && SmarttoolsHelper.isDataTypeInt(tableColumnInfo.getDataType())) && this.isValidColumnName(tableColumnInfo.getColumnName());
        }

        private boolean isNumericValueCheck(TableColumnInfo tableColumnInfo) {
            int dataType = SmarttoolChangeValuesFrame.this.getUsedDataType();
            return SmarttoolChangeValuesFrame.this.getUsedGroup() == 2 && (dataType == tableColumnInfo.getDataType() || dataType == -1 && SmarttoolsHelper.isDataTypeNumeric(tableColumnInfo.getDataType())) && this.isValidColumnName(tableColumnInfo.getColumnName());
        }

        private boolean isDateValueCheck(TableColumnInfo tableColumnInfo) {
            int dataType = SmarttoolChangeValuesFrame.this.getUsedDataType();
            return SmarttoolChangeValuesFrame.this.getUsedGroup() == 4 && (dataType == tableColumnInfo.getDataType() || dataType == -1 && SmarttoolsHelper.isDataTypeDate(tableColumnInfo.getDataType())) && this.isValidColumnName(tableColumnInfo.getColumnName());
        }
    }

    private static interface i18n {
        public static final String GLOBAL_RECORDS = SmarttoolChangeValuesFrame.access$100().getString("global.records");
        public static final String GLOBAL_TABLE = SmarttoolChangeValuesFrame.access$100().getString("global.table");
        public static final String GLOBAL_COLUMN = SmarttoolChangeValuesFrame.access$100().getString("global.column");
        public static final String GLOBAL_DATATYPE = SmarttoolChangeValuesFrame.access$100().getString("global.datatype");
        public static final String GLOBAL_STATUS = SmarttoolChangeValuesFrame.access$100().getString("global.status");
        public static final String GLOBAL_PAGE = SmarttoolChangeValuesFrame.access$100().getString("global.page");
        public static final String GLOBAL_ALIAS = SmarttoolChangeValuesFrame.access$100().getString("global.alias");
        public static final String GLOBAL_OPERATOR = SmarttoolChangeValuesFrame.access$100().getString("global.operator");
        public static final String GLOBAL_VALUE = SmarttoolChangeValuesFrame.access$100().getString("global.value");
        public static final String GLOBAL_BTN_STOP = SmarttoolChangeValuesFrame.access$100().getString("global.lbl.btn.stop");
        public static final String GLOBAL_BTN_PRINT = SmarttoolChangeValuesFrame.access$100().getString("global.lbl.btn.print");
        public static final String GLOBAL_ERROR_FORMAT_INTEGER = SmarttoolChangeValuesFrame.access$100().getString("global.error.format.integer");
        public static final String GLOBAL_ERROR_FORMAT_NUMERIC = SmarttoolChangeValuesFrame.access$100().getString("global.error.format.numeric");
        public static final String GLOBAL_ERROR_FORMAT_DATE = SmarttoolChangeValuesFrame.access$100().getString("global.error.format.date");
        public static final String GLOBAL_ERROR_FORMAT_DATETIME = SmarttoolChangeValuesFrame.access$100().getString("global.error.format.datetime");
        public static final String GLOBAL_ERROR_FORMAT_TIME = SmarttoolChangeValuesFrame.access$100().getString("global.error.format.time");
        public static final String WARNING_TITLE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.info.warning.title");
        public static final String WARNING = SmarttoolChangeValuesFrame.access$100().getString("changevalues.info.warning");
        public static final String LBL_COLUMNNAME = SmarttoolChangeValuesFrame.access$100().getString("changevalues.lbl.columnname");
        public static final String LBL_NEW_VALUE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.lbl.new.value");
        public static final String LBL_WHERE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.lbl.where");
        public static final String LBL_TITLE_RESULT = SmarttoolChangeValuesFrame.access$100().getString("changevalues.lbl.title.result");
        public static final String LBL_BTN_SEARCHDATA = SmarttoolChangeValuesFrame.access$100().getString("changevalues.btn.searchdata");
        public static final String LBL_BTN_CHANGEDATA = SmarttoolChangeValuesFrame.access$100().getString("changevalues.btn.changedata");
        public static final String LBL_BTN_ALL = SmarttoolChangeValuesFrame.access$100().getString("changevalues.btn.select.all");
        public static final String LBL_BTN_NONE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.btn.select.none");
        public static final String LBL_CHK_ONLY_TABLES_WITH_DATA = SmarttoolChangeValuesFrame.access$100().getString("changevalues.chk.lbl.only.tables.with.data");
        public static final String LBL_CHK_ENABLE_CHANGE_DATA = SmarttoolChangeValuesFrame.access$100().getString("changevalues.chk.lbl.enable.change.data");
        public static final String ENTRY_NO_CONDITION = SmarttoolChangeValuesFrame.access$100().getString("changevalues.entry.no.condition");
        public static final String TOOLTIP_WILDCARD = SmarttoolChangeValuesFrame.access$100().getString("changevalues.tooltip.wildcard");
        public static final String TOOLTIP_BTN_ALL = SmarttoolChangeValuesFrame.access$100().getString("changevalues.tooltip.btn.select.all");
        public static final String TOOLTIP_BTN_NONE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.tooltip.btn.select.none");
        public static final String TOOLTIP_TF_OLD_VALUE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.tooltip.old.value");
        public static final String QUESTION_CANCEL_WORK = SmarttoolChangeValuesFrame.access$100().getString("changevalues.question.cancel.work");
        public static final String QUESTION_CANCEL_WORK_TITLE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.question.cancel.work.title");
        public static final String QUESTION_START_CHANGING = SmarttoolChangeValuesFrame.access$100().getString("changevalues.question.start.changing");
        public static final String QUESTION_START_CHANGING_TITLE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.question.start.changing.title");
        public static final String INFO_SEARCHING_FINISHED = SmarttoolChangeValuesFrame.access$100().getString("changevalues.info.searching.finished");
        public static final String INFO_CHANGING_FINISHED = SmarttoolChangeValuesFrame.access$100().getString("changevalues.info.changing.finished");
        public static final String INFO_CHANGING_DATA_FOR_COLUMNNAME = SmarttoolChangeValuesFrame.access$100().getString("changevalues.info.changing.data.for.columnname");
        public static final String ERROR_COLUMNNAME_MISSING = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.columnname.missing");
        public static final String ERROR_SEARCHING_DATA = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.searching.data");
        public static final String ERROR_CHANGING_DATA = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.changing.data");
        public static final String ERROR_ON_TABLE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.on.table");
        public static final String ERROR_CREATING_STATEMENT = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.creating.statement");
        public static final String ERROR_CLOSING_STATEMENT = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.closing.statement");
        public static final String ERROR_SELECT_ENTRY = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.select.entry");
        public static final String ERROR_MISSING_OLD_VALUE = SmarttoolChangeValuesFrame.access$100().getString("changevalues.error.missing.old.value");
    }
}

