/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.greenplum.exp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;

public class GreenplumExtTableParentExpander
implements INodeExpander {
    private static final String SQL = "SELECT c.relname   FROM pg_class c   LEFT OUTER JOIN pg_namespace nspace ON (nspace.oid=c.relnamespace)   LEFT OUTER JOIN pg_exttable ext ON (ext.reloid=c.oid)   LEFT OUTER JOIN pg_authid auth ON (auth.oid=c.relowner)  WHERE  (c.relkind = 'x' OR (c.relkind = 'r' AND c.relstorage = 'x'))   AND nspname = ?  ORDER BY relname ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        ObjFilterMatcher filterMatcher = new ObjFilterMatcher(session.getProperties());
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(SQL);
            pstmt.setString(1, schemaName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo si = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), DatabaseObjectType.TABLE_TYPE_DBO, (ISQLDatabaseMetaData)md);
                if (!filterMatcher.matches(si.getSimpleName())) continue;
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)si));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs, (boolean)true);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return childNodes;
    }
}

