/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import unity.jdbc.UnityDriver;
import unity.query.GlobalQuery;
import unity.query.LocalQuery;

public class QueryThread
implements Runnable {
    private LocalQuery localquery;
    private GlobalQuery gq;

    public QueryThread(LocalQuery localQuery, GlobalQuery globalQuery) {
        this.localquery = localQuery;
        this.gq = globalQuery;
    }

    @Override
    public void run() {
        if (UnityDriver.DEBUG) {
            System.out.println("Started local query: " + this.localquery.getSQLQueryString());
        }
        try {
            long l = System.currentTimeMillis();
            this.localquery.execute(this.gq.getConnection());
            long l2 = System.currentTimeMillis();
            if (UnityDriver.DEBUG) {
                System.out.println("Finished query in time: " + (l2 - l) + "\n\t" + this.localquery.getSQLQueryString());
            }
        }
        catch (Exception exception) {
            this.localquery.setErrorMessage(UnityDriver.i18n.getString("Evaluator.QueryError") + exception);
        }
    }
}

