/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import unity.annotation.SourceField;
import unity.annotation.SourceKey;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQUpdateNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private LQCondNode conditionRoot;
    private GQTableRef tableRef;
    private ArrayList<LQExprNode> fields;
    private ArrayList<LQExprNode> values;
    private GlobalQuery nestedQuery;
    private String subqueryString;
    private int numPKFields;
    private ArrayList<String> pkfields;

    public LQUpdateNode() {
        this.type = 21;
        this.conditionRoot = null;
        this.fields = new ArrayList();
        this.values = new ArrayList();
        this.nestedQuery = null;
    }

    public Object getField(int n) {
        return this.fields.get(n);
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public String getPKField(int n) {
        return this.pkfields.get(n);
    }

    public int getPKFields() {
        return this.numPKFields;
    }

    public String getSubqueryString() {
        return this.subqueryString;
    }

    public void setNestedQuery(GlobalQuery globalQuery) {
        this.nestedQuery = globalQuery;
    }

    public void addSet(LQExprNode lQExprNode, LQExprNode lQExprNode2) {
        this.fields.add(lQExprNode);
        this.values.add(lQExprNode2);
    }

    public void buildSQ(GlobalUpdate globalUpdate) {
        Object object;
        int n;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("SELECT ");
        SourceKey sourceKey = this.tableRef.getTable().getPrimaryKey();
        String string = this.tableRef.getLocalFieldName();
        if (sourceKey == null || sourceKey.getFields().size() == 0) {
            object2 = this.tableRef.getTable().fieldIterator();
            n = 0;
            this.pkfields = new ArrayList();
            while (object2.hasNext()) {
                object = (SourceField)object2.next();
                stringBuffer.append(string + '.' + ((SourceField)object).getColumnName());
                stringBuffer.append(", ");
                this.pkfields.add(((SourceField)object).getColumnName());
                ++n;
            }
            this.numPKFields = n;
        } else {
            this.pkfields = new ArrayList();
            object2 = sourceKey.getFields();
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                object = (SourceField)((ArrayList)object2).get(n);
                stringBuffer.append(string + '.' + ((SourceField)object).getColumnName());
                stringBuffer.append(", ");
                this.pkfields.add(((SourceField)object).getColumnName());
            }
            this.numPKFields = ((ArrayList)object2).size();
        }
        if (this.fields.size() > 0) {
            stringBuffer.append(this.values.get(0).generateSQL() + " as S0 ");
        }
        for (int i = 1; i < this.fields.size(); ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(this.values.get(i).generateSQL() + " as S" + i);
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.tableRef.getParentDB().getName() + '.' + this.tableRef.getLocalName());
        HashMap<String, GQTableRef> hashMap = globalUpdate.getPlan().getTableRefs();
        Iterator<Map.Entry<String, GQTableRef>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getValue();
            if (object == this.tableRef) continue;
            stringBuffer.append(", " + ((GQTableRef)object).getParentDB().getName() + '.' + ((GQTableRef)object).getLocalName());
        }
        stringBuffer.append(" WHERE " + this.conditionRoot.generateSQL() + ';');
        this.subqueryString = stringBuffer.toString();
    }

    public LQCondNode getCondition() {
        return this.conditionRoot;
    }

    public void setCondition(LQCondNode lQCondNode) {
        this.conditionRoot = lQCondNode;
    }

    @Override
    public String generateSQL() {
        if (this.subqueryString == null) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("UPDATE ");
        String string = "";
        if (this.tableRef != null) {
            string = this.tableRef.getTable().getSQLTableNameWithSchema();
            if (this.tableRef.getAliasName() != null) {
                string = string + ' ' + this.tableRef.getAliasName();
            }
        }
        stringBuffer.append(string);
        stringBuffer.append(" SET ");
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("UPDATE ");
        String string = "";
        if (this.tableRef != null) {
            string = this.tableRef.getTable().getSQLTableNameWithSchema();
            if (this.tableRef.getAliasName() != null) {
                string = string + ' ' + this.tableRef.getAliasName();
            }
        }
        stringBuffer.append(string);
        if (this.fields.size() > 0) {
            stringBuffer.append(" SET ");
            stringBuffer.append(this.fields.get(0).generateSQL());
            stringBuffer.append(" = ");
            stringBuffer.append(this.values.get(0).generateSQL());
        }
        for (int i = 1; i < this.fields.size(); ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(this.fields.get(i).generateSQL());
            stringBuffer.append(" = ");
            stringBuffer.append(this.values.get(i).generateSQL());
        }
        if (this.conditionRoot != null) {
            stringBuffer.append(" WHERE " + this.conditionRoot.generateSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        return null;
    }

    @Override
    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        if (this.conditionRoot != null) {
            return this.conditionRoot.getDatabaseRefs(gQDatabaseRef, bl);
        }
        return new HashSet<GQDatabaseRef>();
    }

    public void setTable(GQTableRef gQTableRef) {
        this.tableRef = gQTableRef;
    }

    public GQTableRef getTable() {
        return this.tableRef;
    }

    @Override
    public void computeCost() {
        this.setCost(0.0);
    }
}

