/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import unity.engine.Relation;
import unity.mapping.DatabaseMapping;
import unity.operators.Operator;
import unity.operators.Selection;
import unity.predicates.SelectionPredicate;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQSelNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private LQCondNode conditionRoot;
    public boolean bHavingCondition = false;
    private LQJoinNode complexJoin;
    private BitSet leftTables;
    private BitSet rightTables;

    public LQSelNode() {
        this.type = 2;
    }

    public LQCondNode getCondition() {
        return this.conditionRoot;
    }

    public void setCondition(LQCondNode lQCondNode) {
        this.conditionRoot = lQCondNode;
    }

    @Override
    public String generateSQL() {
        return LQSelNode.genCondition(this.conditionRoot);
    }

    private static String genCondition(LQNode lQNode) {
        return ((LQCondNode)lQNode).generateSQL();
    }

    @Override
    public String toString() {
        if (!this.bHavingCondition) {
            return "SELECT:  " + LQSelNode.genCondition(this.conditionRoot) + super.toString();
        }
        return "HAVING:  " + LQSelNode.genCondition(this.conditionRoot) + super.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        Selection selection = new Selection(operatorArray[0], null, this);
        Operator operator = null;
        operator = subQuery != null ? subQuery.getOperator() : selection;
        SelectionPredicate selectionPredicate = this.conditionRoot.buildSelectionPredicate(operatorArray[0].getOutputRelation(), globalQuery, subQuery, operator);
        selection.setPredicate(selectionPredicate);
        this.outputRelation = new Relation(operatorArray[0].getOutputRelation());
        this.setOperator(selection);
        return selection;
    }

    @Override
    public ArrayList<Object> getRequiredFields() {
        return this.conditionRoot.getRequiredFields();
    }

    @Override
    public int numTuples() {
        double d = this.conditionRoot.getSelectivity();
        int n = ((LQNode)this.children.get(0)).numTuples();
        return (int)((double)n * d);
    }

    @Override
    public int tupleSize() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).tupleSize();
        }
        return 0;
    }

    public void setHavingCondition(boolean bl) {
        this.bHavingCondition = bl;
    }

    public LQJoinNode getComplexJoin() {
        return this.complexJoin;
    }

    public void setComplexJoin(LQJoinNode lQJoinNode) {
        this.complexJoin = lQJoinNode;
        lQJoinNode.setSelNode(this);
    }

    public BitSet getLeftTables() {
        return this.leftTables;
    }

    public BitSet getRightTables() {
        return this.rightTables;
    }

    public void setLeftTables(BitSet bitSet) {
        this.leftTables = bitSet;
    }

    public void setRightTables(BitSet bitSet) {
        this.rightTables = bitSet;
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        if (DatabaseMapping.isSupported("#WHERE#", this.database, null) != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        GQDatabaseRef gQDatabaseRef2 = this.conditionRoot.setDatabase(this.getDatabase(), bl);
        if (gQDatabaseRef2 != null) {
            hashSet.add(gQDatabaseRef2);
        }
        return hashSet;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        this.cost = this.getChild(0).getCost() + (double)l * 1.0;
        this.rows = (long)((double)l * this.conditionRoot.getSelectivity());
    }
}

